/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.platform.win32.User32;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.software.common.AbstractOSVersionInfoEx;
import oshi.util.ParseUtil;
import oshi.util.StringUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsOSVersionInfoEx
extends AbstractOSVersionInfoEx {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG;
    private static final WmiProperty[] OS_PROPERTIES;
    private static final String[] OS_STRINGS;
    private static final WmiUtil.ValueType[] OS_TYPES;

    public WindowsOSVersionInfoEx() {
        Map<String, List<Object>> versionInfo = WmiUtil.selectObjectsFrom(null, "Win32_OperatingSystem", OS_STRINGS, null, OS_TYPES);
        if (versionInfo.get(WmiProperty.VERSION.name()).isEmpty()) {
            LOG.warn("No version data available.");
            this.setVersion(System.getProperty("os.version"));
            this.setCodeName("");
            this.setBuildNumber("");
        } else {
            int suiteMask = (int)((Long)versionInfo.get(WmiProperty.SUITEMASK.name()).get(0)).longValue();
            this.setVersion(this.parseVersion(versionInfo, suiteMask));
            this.setCodeName(this.parseCodeName(suiteMask));
            this.setBuildNumber((String)versionInfo.get(WmiProperty.BUILDNUMBER.name()).get(0));
            LOG.debug("Initialized OSVersionInfoEx");
        }
    }

    private String parseVersion(Map<String, List<Object>> versionInfo, int suiteMask) {
        String sp2;
        boolean ntWorkstation;
        String version = System.getProperty("os.version");
        String[] verSplit = ((String)versionInfo.get(WmiProperty.VERSION.name()).get(0)).split("\\D");
        int major = verSplit.length > 0 ? ParseUtil.parseIntOrDefault(verSplit[0], 0) : 0;
        int minor = verSplit.length > 1 ? ParseUtil.parseIntOrDefault(verSplit[1], 0) : 0;
        boolean bl2 = ntWorkstation = (Long)versionInfo.get(WmiProperty.PRODUCTTYPE.name()).get(0) == 1L;
        if (major == 10) {
            if (minor == 0) {
                version = ntWorkstation ? "10" : "Server 2016";
            }
        } else if (major == 6) {
            if (minor == 3) {
                version = ntWorkstation ? "8.1" : "Server 2012 R2";
            } else if (minor == 2) {
                version = ntWorkstation ? "8" : "Server 2012";
            } else if (minor == 1) {
                version = ntWorkstation ? "7" : "Server 2008 R2";
            } else if (minor == 0) {
                version = ntWorkstation ? "Vista" : "Server 2008";
            }
        } else if (major == 5) {
            if (minor == 2) {
                version = (suiteMask & 0x8000) != 0 ? "Home Server" : (ntWorkstation ? "XP" : (User32.INSTANCE.GetSystemMetrics(89) != 0 ? "Server 2003" : "Server 2003 R2"));
            } else if (minor == 1) {
                version = "XP";
            } else if (minor == 0) {
                version = "2000";
            }
        }
        if (!(sp2 = (String)versionInfo.get(WmiProperty.CSDVERSION.name()).get(0)).isEmpty() && !"unknown".equals(sp2)) {
            version = version + " " + sp2.replace("Service Pack ", "SP");
        }
        return version;
    }

    private String parseCodeName(int suiteMask) {
        ArrayList<String> suites = new ArrayList<String>();
        if ((suiteMask & 2) != 0) {
            suites.add("Enterprise");
        }
        if ((suiteMask & 4) != 0) {
            suites.add("BackOffice");
        }
        if ((suiteMask & 8) != 0) {
            suites.add("Communication Server");
        }
        if ((suiteMask & 0x80) != 0) {
            suites.add("Datacenter");
        }
        if ((suiteMask & 0x200) != 0) {
            suites.add("Home");
        }
        if ((suiteMask & 0x400) != 0) {
            suites.add("Web Server");
        }
        if ((suiteMask & 0x2000) != 0) {
            suites.add("Storage Server");
        }
        if ((suiteMask & 0x4000) != 0) {
            suites.add("Compute Cluster");
        }
        return StringUtil.join(",", suites);
    }

    static {
        int i10;
        LOG = LoggerFactory.getLogger(WindowsOSVersionInfoEx.class);
        OS_PROPERTIES = new WmiProperty[]{WmiProperty.VERSION, WmiProperty.PRODUCTTYPE, WmiProperty.BUILDNUMBER, WmiProperty.CSDVERSION, WmiProperty.SUITEMASK};
        OS_STRINGS = new String[OS_PROPERTIES.length];
        for (i10 = 0; i10 < OS_PROPERTIES.length; ++i10) {
            WindowsOSVersionInfoEx.OS_STRINGS[i10] = OS_PROPERTIES[i10].name();
        }
        OS_TYPES = new WmiUtil.ValueType[OS_PROPERTIES.length];
        for (i10 = 0; i10 < OS_PROPERTIES.length; ++i10) {
            WindowsOSVersionInfoEx.OS_TYPES[i10] = OS_PROPERTIES[i10].getType();
        }
    }

    static enum WmiProperty {
        VERSION(WmiUtil.ValueType.STRING),
        PRODUCTTYPE(WmiUtil.ValueType.UINT32),
        BUILDNUMBER(WmiUtil.ValueType.STRING),
        CSDVERSION(WmiUtil.ValueType.STRING),
        SUITEMASK(WmiUtil.ValueType.UINT32);

        private WmiUtil.ValueType type;

        public WmiUtil.ValueType getType() {
            return this.type;
        }

        private WmiProperty(WmiUtil.ValueType type) {
            this.type = type;
        }
    }
}

