/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.util.ParseUtil;

public class EdidUtil {
    private static final Logger LOG = LoggerFactory.getLogger(EdidUtil.class);

    private EdidUtil() {
    }

    public static String getManufacturerID(byte[] edid) {
        String temp = String.format("%8s%8s", Integer.toBinaryString(edid[8] & 0xFF), Integer.toBinaryString(edid[9] & 0xFF)).replace(' ', '0');
        LOG.debug("Manufacurer ID: {}", (Object)temp);
        return String.format("%s%s%s", Character.valueOf((char)(64 + Integer.parseInt(temp.substring(1, 6), 2))), Character.valueOf((char)(64 + Integer.parseInt(temp.substring(7, 11), 2))), Character.valueOf((char)(64 + Integer.parseInt(temp.substring(12, 16), 2)))).replace("@", "");
    }

    public static String getProductID(byte[] edid) {
        return Integer.toHexString(ByteBuffer.wrap(Arrays.copyOfRange(edid, 10, 12)).order(ByteOrder.LITTLE_ENDIAN).getShort() & 0xFFFF);
    }

    public static String getSerialNo(byte[] edid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Serial number: {}", (Object)Arrays.toString(Arrays.copyOfRange(edid, 12, 16)));
        }
        return String.format("%s%s%s%s", EdidUtil.getAlphaNumericOrHex(edid[15]), EdidUtil.getAlphaNumericOrHex(edid[14]), EdidUtil.getAlphaNumericOrHex(edid[13]), EdidUtil.getAlphaNumericOrHex(edid[12]));
    }

    private static String getAlphaNumericOrHex(byte b10) {
        return Character.isLetterOrDigit((char)b10) ? String.format("%s", Character.valueOf((char)b10)) : String.format("%02X", b10);
    }

    public static byte getWeek(byte[] edid) {
        return edid[16];
    }

    public static int getYear(byte[] edid) {
        byte temp = edid[17];
        LOG.debug("Year-1990: {}", (Object)temp);
        return temp + 1990;
    }

    public static String getVersion(byte[] edid) {
        return edid[18] + "." + edid[19];
    }

    public static boolean isDigital(byte[] edid) {
        return 1 == (edid[20] & 0xFF) >> 7;
    }

    public static int getHcm(byte[] edid) {
        return edid[21];
    }

    public static int getVcm(byte[] edid) {
        return edid[22];
    }

    public static byte[][] getDescriptors(byte[] edid) {
        byte[][] desc = new byte[4][18];
        for (int i10 = 0; i10 < desc.length; ++i10) {
            System.arraycopy(edid, 54 + 18 * i10, desc[i10], 0, 18);
        }
        return desc;
    }

    public static int getDescriptorType(byte[] desc) {
        return ByteBuffer.wrap(Arrays.copyOfRange(desc, 0, 4)).getInt();
    }

    public static String getTimingDescriptor(byte[] desc) {
        int clock = ByteBuffer.wrap(Arrays.copyOfRange(desc, 0, 2)).order(ByteOrder.LITTLE_ENDIAN).getShort() / 100;
        int hActive = (desc[2] & 0xFF) + ((desc[4] & 0xF0) << 4);
        int vActive = (desc[5] & 0xFF) + ((desc[7] & 0xF0) << 4);
        return String.format("Clock %dMHz, Active Pixels %dx%d ", clock, hActive, vActive);
    }

    public static String getDescriptorRangeLimits(byte[] desc) {
        return String.format("Field Rate %d-%d Hz vertical, %d-%d Hz horizontal, Max clock: %d MHz", desc[5], desc[6], desc[7], desc[8], desc[9] * 10);
    }

    public static String getDescriptorText(byte[] desc) {
        return new String(Arrays.copyOfRange(desc, 4, 18)).trim();
    }

    public static String toString(byte[] edid) {
        byte[][] desc;
        StringBuilder sb2 = new StringBuilder();
        sb2.append("  Manuf. ID=").append(EdidUtil.getManufacturerID(edid)).append(", Product ID=").append(EdidUtil.getProductID(edid)).append(", ").append(EdidUtil.isDigital(edid) ? "Digital" : "Analog").append(", Serial=").append(EdidUtil.getSerialNo(edid)).append(", ManufDate=").append(EdidUtil.getWeek(edid) * 12 / 52 + 1 + "/").append(EdidUtil.getYear(edid)).append(", EDID v").append(EdidUtil.getVersion(edid));
        int hSize = EdidUtil.getHcm(edid);
        int vSize = EdidUtil.getVcm(edid);
        sb2.append(String.format("%n  %d x %d cm (%.1f x %.1f in)", hSize, vSize, (double)hSize / 2.54, (double)vSize / 2.54));
        block8: for (byte[] b10 : desc = EdidUtil.getDescriptors(edid)) {
            switch (EdidUtil.getDescriptorType(b10)) {
                case 255: {
                    sb2.append("\n  Serial Number: ").append(EdidUtil.getDescriptorText(b10));
                    continue block8;
                }
                case 254: {
                    sb2.append("\n  Unspecified Text: ").append(EdidUtil.getDescriptorText(b10));
                    continue block8;
                }
                case 253: {
                    sb2.append("\n  Range Limits: ").append(EdidUtil.getDescriptorRangeLimits(b10));
                    continue block8;
                }
                case 252: {
                    sb2.append("\n  Monitor Name: ").append(EdidUtil.getDescriptorText(b10));
                    continue block8;
                }
                case 251: {
                    sb2.append("\n  White Point Data: ").append(ParseUtil.byteArrayToHexString(b10));
                    continue block8;
                }
                case 250: {
                    sb2.append("\n  Standard Timing ID: ").append(ParseUtil.byteArrayToHexString(b10));
                    continue block8;
                }
                default: {
                    if (EdidUtil.getDescriptorType(b10) <= 15 && EdidUtil.getDescriptorType(b10) >= 0) {
                        sb2.append("\n  Manufacturer Data: ").append(ParseUtil.byteArrayToHexString(b10));
                        continue block8;
                    }
                    sb2.append("\n  Preferred Timing: ").append(EdidUtil.getTimingDescriptor(b10));
                }
            }
        }
        return sb2.toString();
    }
}

