/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutingCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutingCommand.class);

    private ExecutingCommand() {
    }

    public static List<String> runNative(String cmdToRun) {
        String[] cmd = cmdToRun.split(" ");
        return ExecutingCommand.runNative(cmd);
    }

    public static List<String> runNative(String[] cmdToRunWithArgs) {
        Process p10 = null;
        try {
            p10 = Runtime.getRuntime().exec(cmdToRunWithArgs);
        }
        catch (IOException | SecurityException e10) {
            LOG.trace("Couldn't run command {}: {}", (Object)cmdToRunWithArgs, (Object)e10);
            return new ArrayList<String>(0);
        }
        ArrayList<String> sa2 = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(p10.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                sa2.add(line);
            }
            p10.waitFor();
        }
        catch (IOException e11) {
            LOG.trace("Problem reading output from {}: {}", (Object)cmdToRunWithArgs, (Object)e11);
            return new ArrayList<String>(0);
        }
        catch (InterruptedException ie2) {
            LOG.trace("Interrupted while reading output from {}: {}", (Object)cmdToRunWithArgs, (Object)ie2);
            Thread.currentThread().interrupt();
        }
        return sa2;
    }

    public static String getFirstAnswer(String cmd2launch) {
        return ExecutingCommand.getAnswerAt(cmd2launch, 0);
    }

    public static String getAnswerAt(String cmd2launch, int answerIdx) {
        List<String> sa2 = ExecutingCommand.runNative(cmd2launch);
        if (answerIdx >= 0 && answerIdx < sa2.size()) {
            return sa2.get(answerIdx);
        }
        return "";
    }
}

