/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.LocalDate;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.format.DateTimeParseException;

public class FormatUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FormatUtil.class);
    private static final long KIBI = 1024L;
    private static final long MEBI = 0x100000L;
    private static final long GIBI = 0x40000000L;
    private static final long TEBI = 0x10000000000L;
    private static final long PEBI = 0x4000000000000L;
    private static final long EXBI = 0x1000000000000000L;
    private static final long KILO = 1000L;
    private static final long MEGA = 1000000L;
    private static final long GIGA = 1000000000L;
    private static final long TERA = 1000000000000L;
    private static final long PETA = 1000000000000000L;
    private static final long EXA = 1000000000000000000L;
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("MM/dd/yyyy");
    private static final BigInteger TWOS_COMPLEMENT_REF = BigInteger.ONE.shiftLeft(64);

    private FormatUtil() {
    }

    public static String formatBytes(long bytes) {
        if (bytes == 1L) {
            return String.format("%d byte", bytes);
        }
        if (bytes < 1024L) {
            return String.format("%d bytes", bytes);
        }
        if (bytes < 0x100000L) {
            return FormatUtil.formatUnits(bytes, 1024L, "KiB");
        }
        if (bytes < 0x40000000L) {
            return FormatUtil.formatUnits(bytes, 0x100000L, "MiB");
        }
        if (bytes < 0x10000000000L) {
            return FormatUtil.formatUnits(bytes, 0x40000000L, "GiB");
        }
        if (bytes < 0x4000000000000L) {
            return FormatUtil.formatUnits(bytes, 0x10000000000L, "TiB");
        }
        if (bytes < 0x1000000000000000L) {
            return FormatUtil.formatUnits(bytes, 0x4000000000000L, "PiB");
        }
        return FormatUtil.formatUnits(bytes, 0x1000000000000000L, "EiB");
    }

    private static String formatUnits(long value, long prefix, String unit) {
        if (value % prefix == 0L) {
            return String.format("%d %s", value / prefix, unit);
        }
        return String.format("%.1f %s", (double)value / (double)prefix, unit);
    }

    public static String formatBytesDecimal(long bytes) {
        if (bytes == 1L) {
            return String.format("%d byte", bytes);
        }
        if (bytes < 1000L) {
            return String.format("%d bytes", bytes);
        }
        return FormatUtil.formatValue(bytes, "B");
    }

    public static String formatHertz(long hertz) {
        return FormatUtil.formatValue(hertz, "Hz");
    }

    public static String formatValue(long value, String unit) {
        if (value < 1000L) {
            return String.format("%d %s", value, unit);
        }
        if (value < 1000000L) {
            return FormatUtil.formatUnits(value, 1000L, "K" + unit);
        }
        if (value < 1000000000L) {
            return FormatUtil.formatUnits(value, 1000000L, "M" + unit);
        }
        if (value < 1000000000000L) {
            return FormatUtil.formatUnits(value, 1000000000L, "G" + unit);
        }
        if (value < 1000000000000000L) {
            return FormatUtil.formatUnits(value, 1000000000000L, "T" + unit);
        }
        if (value < 1000000000000000000L) {
            return FormatUtil.formatUnits(value, 1000000000000000L, "P" + unit);
        }
        return FormatUtil.formatUnits(value, 1000000000000000000L, "E" + unit);
    }

    public static String formatElapsedSecs(long secs) {
        long eTime = secs;
        long days = TimeUnit.SECONDS.toDays(eTime);
        long hr2 = TimeUnit.SECONDS.toHours(eTime -= TimeUnit.DAYS.toSeconds(days));
        long min = TimeUnit.SECONDS.toMinutes(eTime -= TimeUnit.HOURS.toSeconds(hr2));
        long sec = eTime -= TimeUnit.MINUTES.toSeconds(min);
        return String.format("%d days, %02d:%02d:%02d", days, hr2, min, sec);
    }

    public static float round(float d10, int decimalPlace) {
        BigDecimal bd2 = new BigDecimal(Float.toString(d10)).setScale(decimalPlace, 4);
        return bd2.floatValue();
    }

    public static long getUnsignedInt(int x10) {
        return (long)x10 & 0xFFFFFFFFL;
    }

    public static String formatDate(LocalDate date) {
        return date == null ? "null" : date.format(DATE_FORMATTER);
    }

    public static LocalDate formatStringDate(String date) {
        try {
            return date == null ? null : LocalDate.parse(date, DATE_FORMATTER);
        }
        catch (DateTimeParseException dtpe) {
            LOG.warn("Date parse error: {}", dtpe);
            return null;
        }
    }

    public static String toUnsignedString(int i10) {
        if (i10 >= 0) {
            return Integer.toString(i10);
        }
        return Long.toString(FormatUtil.getUnsignedInt(i10));
    }

    public static String toUnsignedString(long l10) {
        if (l10 >= 0L) {
            return Long.toString(l10);
        }
        return BigInteger.valueOf(l10).add(TWOS_COMPLEMENT_REF).toString();
    }

    public static String join(CharSequence delimiter, CharSequence ... elements) {
        StringBuilder sb2 = new StringBuilder();
        boolean first = true;
        for (CharSequence cs2 : elements) {
            if (first) {
                first = false;
            } else {
                sb2.append(delimiter);
            }
            sb2.append(cs2);
        }
        return sb2.toString();
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        StringBuilder sb2 = new StringBuilder();
        Iterator<? extends CharSequence> iter = elements.iterator();
        if (iter.hasNext()) {
            sb2.append(((Object)iter.next()).toString());
        }
        while (iter.hasNext()) {
            sb2.append(delimiter);
            sb2.append(((Object)iter.next()).toString());
        }
        return sb2.toString();
    }
}

