/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);

    private Util() {
    }

    public static void sleep(long ms2) {
        try {
            LOG.trace("Sleeping for {} ms", (Object)ms2);
            Thread.sleep(ms2);
        }
        catch (InterruptedException e10) {
            LOG.warn("Interrupted while sleeping for {} ms: {}", (Object)ms2, (Object)e10);
        }
    }

    public static void sleepAfter(long startTime, long ms2) {
        long now = System.currentTimeMillis();
        long until = startTime + ms2;
        LOG.trace("Sleeping until {}", (Object)until);
        if (now < until) {
            Util.sleep(until - now);
        }
    }
}

