/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.windows;

import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Pdh;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdhUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PdhUtil.class);
    private static final BaseTSD.DWORD_PTR PZERO = new BaseTSD.DWORD_PTR(0L);
    private static final WinDef.DWORDByReference PDH_FMT_RAW = new WinDef.DWORDByReference(new WinDef.DWORD(16L));
    private static final Pdh.PDH_RAW_COUNTER counterValue = new Pdh.PDH_RAW_COUNTER();
    private static final Pdh PDH = Pdh.INSTANCE;
    private static final String HEX_ERROR_FMT = "0x%08X";
    private static final String LOG_COUNTER_NOT_EXISTS = "Counter does not exist: {}";
    private static final Map<String, WinNT.HANDLEByReference> counterMap = new HashMap<String, WinNT.HANDLEByReference>();
    private static final Map<String, WinNT.HANDLEByReference> queryMap = new HashMap<String, WinNT.HANDLEByReference>();

    private PdhUtil() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (WinNT.HANDLEByReference query : queryMap.values()) {
                    PDH.PdhCloseQuery(query.getValue());
                }
            }
        });
    }

    public static boolean isCounter(String counterString) {
        return counterMap.containsKey(counterString);
    }

    public static boolean addCounter(String counterString) {
        if (queryMap.containsKey(counterString)) {
            LOG.warn("Counter already exists: {}", (Object)counterString);
            return true;
        }
        WinNT.HANDLEByReference q10 = new WinNT.HANDLEByReference();
        if (PdhUtil.openQuery(q10)) {
            WinNT.HANDLEByReference p10 = new WinNT.HANDLEByReference();
            PdhUtil.addCounter(q10, counterString, p10);
            counterMap.put(counterString, p10);
            queryMap.put(counterString, q10);
            return true;
        }
        return false;
    }

    public static boolean addCounter2DArray(String name, String[][] counterStringArray) {
        if (queryMap.containsKey(name)) {
            LOG.warn("Counters already exists: {}", (Object)name);
            return true;
        }
        if (counterStringArray.length == 0 || counterStringArray[0].length == 0) {
            LOG.error("This array has a zero dimension: {}", (Object)name);
            return false;
        }
        WinNT.HANDLEByReference q10 = new WinNT.HANDLEByReference();
        if (PdhUtil.openQuery(q10)) {
            for (int i10 = 0; i10 < counterStringArray.length; ++i10) {
                for (int j10 = 0; j10 < counterStringArray[i10].length; ++j10) {
                    if (counterStringArray[i10][j10] == null) continue;
                    WinNT.HANDLEByReference p10 = new WinNT.HANDLEByReference();
                    PdhUtil.addCounter(q10, counterStringArray[i10][j10], p10);
                    counterMap.put(counterStringArray[i10][j10], p10);
                }
            }
            queryMap.put(name, q10);
            return true;
        }
        return false;
    }

    public static void removeCounter(String counterString) {
        if (queryMap.containsKey(counterString)) {
            PDH.PdhCloseQuery(queryMap.get(counterString).getValue());
            counterMap.remove(counterString);
            queryMap.remove(counterString);
        } else {
            LOG.warn(LOG_COUNTER_NOT_EXISTS, (Object)counterString);
        }
    }

    public static long queryCounter(String counterString) {
        if (!queryMap.containsKey(counterString)) {
            LOG.error(LOG_COUNTER_NOT_EXISTS, (Object)counterString);
            return 0L;
        }
        PdhUtil.updateCounters(queryMap.get(counterString));
        return PdhUtil.queryCounter(counterMap.get(counterString));
    }

    public static long queryCounterTimestamp(String counterString) {
        if (!queryMap.containsKey(counterString)) {
            LOG.error(LOG_COUNTER_NOT_EXISTS, (Object)counterString);
            return 0L;
        }
        return PdhUtil.queryCounterTimestamp(counterMap.get(counterString)).toDWordLong().longValue() / 10000L;
    }

    public static long[][] queryCounter2DArray(String name, String[][] counterStringArray) {
        if (!queryMap.containsKey(name)) {
            LOG.error(LOG_COUNTER_NOT_EXISTS, (Object)name);
            return new long[0][0];
        }
        if (counterStringArray.length == 0 || counterStringArray[0].length == 0) {
            LOG.error("This array has a zero dimension: {}", (Object)name);
            return new long[0][0];
        }
        PdhUtil.updateCounters(queryMap.get(name));
        long[][] values = new long[counterStringArray.length][counterStringArray[0].length];
        for (int i10 = 0; i10 < counterStringArray.length; ++i10) {
            for (int j10 = 0; j10 < counterStringArray[i10].length; ++j10) {
                if (counterStringArray[i10][j10] == null) continue;
                values[i10][j10] = PdhUtil.queryCounter(counterMap.get(counterStringArray[i10][j10]));
            }
        }
        return values;
    }

    private static boolean openQuery(WinNT.HANDLEByReference p10) {
        int pdhOpenQueryError = PDH.PdhOpenQuery(null, PZERO, p10);
        if (pdhOpenQueryError != 0 && LOG.isErrorEnabled()) {
            LOG.error("Failed to open PDH Query. Error code: {}", (Object)String.format(HEX_ERROR_FMT, pdhOpenQueryError));
        }
        return pdhOpenQueryError == 0;
    }

    private static void addCounter(WinNT.HANDLEByReference query, String path, WinNT.HANDLEByReference p10) {
        int pdhAddCounterError = PDH.PdhAddEnglishCounter(query.getValue(), path, PZERO, p10);
        if (pdhAddCounterError != 0 && LOG.isErrorEnabled()) {
            LOG.error("Failed to add PDH Counter: {}, Error code: {}", (Object)path, (Object)String.format(HEX_ERROR_FMT, pdhAddCounterError));
        }
    }

    private static boolean updateCounters(WinNT.HANDLEByReference query) {
        int ret = PDH.PdhCollectQueryData(query.getValue());
        if (ret != 0 && LOG.isErrorEnabled()) {
            LOG.error("Failed to update counters. Error code: {}", (Object)String.format(HEX_ERROR_FMT, ret));
            return false;
        }
        return true;
    }

    private static long queryCounter(WinNT.HANDLEByReference counter) {
        int ret = PDH.PdhGetRawCounterValue(counter.getValue(), PDH_FMT_RAW, counterValue);
        if (ret != 0 && LOG.isErrorEnabled()) {
            LOG.warn("Failed to get counter. Error code: {}", (Object)String.format(HEX_ERROR_FMT, ret));
            return 0L;
        }
        return PdhUtil.counterValue.FirstValue;
    }

    private static WinBase.FILETIME queryCounterTimestamp(WinNT.HANDLEByReference counter) {
        int ret = PDH.PdhGetRawCounterValue(counter.getValue(), PDH_FMT_RAW, counterValue);
        if (ret != 0 && LOG.isErrorEnabled()) {
            LOG.warn("Failed to get counter. Error code: {}", (Object)String.format(HEX_ERROR_FMT, ret));
            return new WinBase.FILETIME();
        }
        return PdhUtil.counterValue.TimeStamp;
    }
}

