/*
 * Decompiled with CFR 0.152.
 */
package sockslib.client;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.client.SocksMessage;
import sockslib.utils.SocksUtil;

public class CommandReplyMessage
implements SocksMessage {
    protected Logger logger = LoggerFactory.getLogger(CommandReplyMessage.class);
    private byte[] replyBytes;

    public CommandReplyMessage(byte[] replyBytes) {
        this.replyBytes = replyBytes;
    }

    public boolean isSuccess() {
        if (this.replyBytes.length < 10) {
            return false;
        }
        return this.replyBytes[1] == 0;
    }

    public InetAddress getIp() throws UnknownHostException {
        byte[] addressBytes = null;
        if (this.replyBytes[3] == 1) {
            addressBytes = new byte[4];
        } else if (this.replyBytes[3] == 4) {
            addressBytes = new byte[16];
        }
        System.arraycopy(this.replyBytes, 4, addressBytes, 0, addressBytes.length);
        return InetAddress.getByAddress(addressBytes);
    }

    public int getPort() {
        return SocksUtil.bytesToInt(this.replyBytes[this.replyBytes.length - 2], this.replyBytes[this.replyBytes.length - 1]);
    }

    public byte[] getReplyBytes() {
        return this.replyBytes;
    }

    public void setReplyBytes(byte[] replyBytes) {
        this.replyBytes = replyBytes;
    }

    public SocketAddress getSocketAddress() {
        try {
            return new InetSocketAddress(this.getIp(), this.getPort());
        }
        catch (UnknownHostException e10) {
            this.logger.error(e10.getMessage(), e10);
            return null;
        }
    }
}

