/*
 * Decompiled with CFR 0.152.
 */
package sockslib.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.client.CommandReplyMessage;
import sockslib.client.SocksCommandSender;
import sockslib.common.ProtocolErrorException;
import sockslib.common.SocksCommand;
import sockslib.common.SocksException;
import sockslib.utils.LogMessageBuilder;
import sockslib.utils.UnsignedByte;

public class GenericSocksCommandSender
implements SocksCommandSender {
    protected static final Logger logger = LoggerFactory.getLogger(GenericSocksCommandSender.class);
    protected static final int LENGTH_OF_IPV4 = 4;
    protected static final int LENGTH_OF_IPV6 = 16;

    @Override
    public CommandReplyMessage send(Socket socket, SocksCommand command, InetAddress address, int port, int version) throws SocksException, IOException {
        return this.send(socket, command, new InetSocketAddress(address, port), version);
    }

    @Override
    public CommandReplyMessage send(Socket socket, SocksCommand command, SocketAddress socketAddress, int version) throws SocksException, IOException {
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        InetSocketAddress address = (InetSocketAddress)socketAddress;
        byte[] bytesOfAddress = address.getAddress().getAddress();
        int ADDRESS_LENGTH = bytesOfAddress.length;
        int port = address.getPort();
        int addressType = -1;
        byte[] bufferSent = null;
        if (ADDRESS_LENGTH == 4) {
            addressType = 1;
            bufferSent = new byte[10];
        } else if (ADDRESS_LENGTH == 16) {
            addressType = 4;
            bufferSent = new byte[22];
        } else {
            throw new SocksException("Address error");
        }
        bufferSent[0] = (byte)version;
        bufferSent[1] = (byte)command.getValue();
        bufferSent[2] = 0;
        bufferSent[3] = addressType;
        System.arraycopy(bytesOfAddress, 0, bufferSent, 4, ADDRESS_LENGTH);
        bufferSent[4 + ADDRESS_LENGTH] = (byte)((port & 0xFF00) >> 8);
        bufferSent[5 + ADDRESS_LENGTH] = (byte)(port & 0xFF);
        outputStream.write(bufferSent);
        outputStream.flush();
        logger.debug("{}", (Object)LogMessageBuilder.build(bufferSent, LogMessageBuilder.MsgType.SEND));
        return this.checkServerReply(inputStream);
    }

    @Override
    public CommandReplyMessage send(Socket socket, SocksCommand command, String host, int port, int version) throws SocksException, IOException {
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        int lengthOfHost = host.getBytes().length;
        byte[] bufferSent = new byte[7 + lengthOfHost];
        bufferSent[0] = (byte)version;
        bufferSent[1] = (byte)command.getValue();
        bufferSent[2] = 0;
        bufferSent[3] = 3;
        bufferSent[4] = (byte)lengthOfHost;
        byte[] bytesOfHost = host.getBytes();
        System.arraycopy(bytesOfHost, 0, bufferSent, 5, lengthOfHost);
        bufferSent[5 + host.length()] = (byte)((port & 0xFF00) >> 8);
        bufferSent[6 + host.length()] = (byte)(port & 0xFF);
        outputStream.write(bufferSent);
        outputStream.flush();
        logger.debug("{}", (Object)LogMessageBuilder.build(bufferSent, LogMessageBuilder.MsgType.SEND));
        return this.checkServerReply(inputStream);
    }

    @Override
    public CommandReplyMessage checkServerReply(InputStream inputStream) throws SocksException, IOException {
        int size;
        byte serverReply = -1;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int temp = 0;
        for (int i10 = 0; i10 < 4; ++i10) {
            temp = inputStream.read();
            byteArrayOutputStream.write(temp);
        }
        byte addressType = (byte)temp;
        switch (addressType) {
            case 1: {
                int i11;
                for (i11 = 0; i11 < 6; ++i11) {
                    byteArrayOutputStream.write(inputStream.read());
                }
                break;
            }
            case 3: {
                int i11;
                temp = inputStream.read();
                byteArrayOutputStream.write(temp);
                for (i11 = 0; i11 < temp + 2; ++i11) {
                    byteArrayOutputStream.write(inputStream.read());
                }
                break;
            }
            case 4: {
                int i11;
                for (i11 = 0; i11 < 18; ++i11) {
                    byteArrayOutputStream.write(inputStream.read());
                }
                break;
            }
            default: {
                throw new ProtocolErrorException("Address type not support, type value: " + addressType);
            }
        }
        byte[] receivedData = byteArrayOutputStream.toByteArray();
        int length = receivedData.length;
        logger.debug("{}", (Object)LogMessageBuilder.build(receivedData, length, LogMessageBuilder.MsgType.RECEIVE));
        byte[] addressBytes = null;
        byte[] portBytes = new byte[2];
        if (receivedData[3] == 1) {
            addressBytes = new byte[4];
            System.arraycopy(receivedData, 4, addressBytes, 0, addressBytes.length);
            int a10 = UnsignedByte.toInt(addressBytes[0]);
            int b10 = UnsignedByte.toInt(addressBytes[1]);
            int c10 = UnsignedByte.toInt(addressBytes[2]);
            int d10 = UnsignedByte.toInt(addressBytes[3]);
            portBytes[0] = receivedData[8];
            portBytes[1] = receivedData[9];
            logger.debug("Server replied:Address as IPv4:{}.{}.{}.{}, port:{}", a10, b10, c10, d10, UnsignedByte.toInt(portBytes[0]) << 8 | UnsignedByte.toInt(portBytes[1]));
        } else if (receivedData[3] == 3) {
            size = receivedData[4];
            addressBytes = new byte[size &= 0xFF];
            System.arraycopy(receivedData, 4, addressBytes, 0, size);
            portBytes[0] = receivedData[4 + size];
            portBytes[1] = receivedData[5 + size];
            logger.debug("Server replied:Address as host:{}, port:{}", (Object)new String(addressBytes), (Object)(UnsignedByte.toInt(portBytes[0]) << 8 | UnsignedByte.toInt(portBytes[1])));
        } else if (receivedData[3] == 4) {
            size = receivedData[4];
            size &= 0xFF;
            addressBytes = new byte[16];
            for (int i12 = 0; i12 < addressBytes.length; ++i12) {
                addressBytes[i12] = receivedData[4 + i12];
            }
            logger.debug("Server replied:Address as IPv6:{}", (Object)new String(addressBytes));
        }
        serverReply = receivedData[1];
        if (serverReply != 0) {
            throw SocksException.serverReplyException(serverReply);
        }
        logger.debug("SOCKS server response success");
        byte[] receivedBytes = new byte[length];
        System.arraycopy(receivedData, 0, receivedBytes, 0, length);
        return new CommandReplyMessage(receivedBytes);
    }
}

