/*
 * Decompiled with CFR 0.152.
 */
package sockslib.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.client.SocksMethodRequester;
import sockslib.common.SocksException;
import sockslib.common.methods.SocksMethod;
import sockslib.common.methods.SocksMethodRegistry;
import sockslib.utils.LogMessageBuilder;
import sockslib.utils.StreamUtil;

public class GenericSocksMethodRequester
implements SocksMethodRequester {
    protected static final Logger logger = LoggerFactory.getLogger(GenericSocksMethodRequester.class);

    @Override
    public SocksMethod doRequest(List<SocksMethod> acceptableMethods, Socket socket, int socksVersion) throws SocksException, IOException {
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        byte[] bufferSent = new byte[2 + acceptableMethods.size()];
        bufferSent[0] = (byte)socksVersion;
        bufferSent[1] = (byte)acceptableMethods.size();
        for (int i10 = 0; i10 < acceptableMethods.size(); ++i10) {
            bufferSent[2 + i10] = (byte)acceptableMethods.get(i10).getByte();
        }
        outputStream.write(bufferSent);
        outputStream.flush();
        logger.debug("{}", (Object)LogMessageBuilder.build(bufferSent, LogMessageBuilder.MsgType.SEND));
        byte[] receivedData = StreamUtil.read(inputStream, 2);
        logger.debug("{}", (Object)LogMessageBuilder.build(receivedData, LogMessageBuilder.MsgType.RECEIVE));
        if (receivedData[0] != socksVersion) {
            throw new SocksException("Remote server don't support SOCKS5");
        }
        return SocksMethodRegistry.getByByte(receivedData[1]);
    }
}

