/*
 * Decompiled with CFR 0.152.
 */
package sockslib.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.client.CommandReplyMessage;
import sockslib.client.GenericSocksCommandSender;
import sockslib.client.GenericSocksMethodRequester;
import sockslib.client.SocksCommandSender;
import sockslib.client.SocksMethodRequester;
import sockslib.client.SocksProxy;
import sockslib.common.AnonymousCredentials;
import sockslib.common.Credentials;
import sockslib.common.SocksCommand;
import sockslib.common.SocksException;
import sockslib.common.UsernamePasswordCredentials;
import sockslib.common.methods.GssApiMethod;
import sockslib.common.methods.NoAuthenticationRequiredMethod;
import sockslib.common.methods.SocksMethod;
import sockslib.common.methods.SocksMethodRegistry;
import sockslib.common.methods.UsernamePasswordMethod;

public class Socks5
implements SocksProxy {
    public static final byte SOCKS_VERSION = 5;
    public static final byte RESERVED = 0;
    public static final int REP_SUCCEEDED = 0;
    public static final int REP_GENERAL_SOCKS_SERVER_FAILURE = 1;
    public static final int REP_CONNECTION_NOT_ALLOWED_BY_RULESET = 2;
    public static final int REP_NETWORK_UNREACHABLE = 3;
    public static final int REP_HOST_UNREACHABLE = 4;
    public static final int REP_CONNECTION_REFUSED = 5;
    public static final int REP_TTL_EXPIRED = 6;
    public static final int REP_COMMAND_NOT_SUPPORTED = 7;
    public static final int REP_ADDRESS_TYPE_NOT_SUPPORTED = 8;
    public static final byte AUTHENTICATION_SUCCEEDED = 0;
    protected static final Logger logger = LoggerFactory.getLogger(Socks5.class);
    private SocksProxy chainProxy;
    private Credentials credentials = new AnonymousCredentials();
    private InetAddress inetAddress;
    private int port = 1080;
    private Socket proxySocket;
    private List<SocksMethod> acceptableMethods;
    private SocksMethodRequester socksMethodRequester = new GenericSocksMethodRequester();
    private SocksCommandSender socksCmdSender = new GenericSocksCommandSender();
    private boolean alwaysResolveAddressLocally = false;

    public Socks5(SocketAddress socketAddress, String username, String password) {
        this(socketAddress);
        this.setCredentials(new UsernamePasswordCredentials(username, password));
    }

    public Socks5(String host, int port) throws UnknownHostException {
        this(InetAddress.getByName(host), port);
    }

    public Socks5(InetAddress inetAddress, int port) {
        this(new InetSocketAddress(inetAddress, port));
    }

    public Socks5(SocketAddress socketAddress) {
        this(null, socketAddress);
    }

    public Socks5(SocksProxy chainProxy, SocketAddress socketAddress) {
        this.init();
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Only supports java.net.InetSocketAddress");
        }
        this.inetAddress = ((InetSocketAddress)socketAddress).getAddress();
        this.port = ((InetSocketAddress)socketAddress).getPort();
        this.setChainProxy(chainProxy);
    }

    public Socks5(String host, int port, Credentials credentials) throws UnknownHostException {
        this.init();
        this.inetAddress = InetAddress.getByName(host);
        this.port = port;
        this.credentials = credentials;
    }

    private void init() {
        this.acceptableMethods = new ArrayList<SocksMethod>();
        this.acceptableMethods.add(new NoAuthenticationRequiredMethod());
        this.acceptableMethods.add(new GssApiMethod());
        this.acceptableMethods.add(new UsernamePasswordMethod());
    }

    @Override
    public void buildConnection() throws SocksException, IOException {
        if (this.inetAddress == null) {
            throw new IllegalArgumentException("Please set inetAddress before calling buildConnection.");
        }
        if (this.proxySocket == null) {
            this.proxySocket = this.createProxySocket(this.inetAddress, this.port);
        } else if (!this.proxySocket.isConnected()) {
            this.proxySocket.connect(new InetSocketAddress(this.inetAddress, this.port));
        }
        SocksMethod method = this.socksMethodRequester.doRequest(this.acceptableMethods, this.proxySocket, 5);
        method.doMethod(this);
    }

    @Override
    public CommandReplyMessage requestConnect(String host, int port) throws SocksException, IOException {
        if (!this.alwaysResolveAddressLocally) {
            return this.socksCmdSender.send(this.proxySocket, SocksCommand.CONNECT, host, port, 5);
        }
        InetAddress address = InetAddress.getByName(host);
        return this.socksCmdSender.send(this.proxySocket, SocksCommand.CONNECT, address, port, 5);
    }

    @Override
    public CommandReplyMessage requestConnect(InetAddress address, int port) throws SocksException, IOException {
        return this.socksCmdSender.send(this.proxySocket, SocksCommand.CONNECT, address, port, 5);
    }

    @Override
    public CommandReplyMessage requestConnect(SocketAddress address) throws SocksException, IOException {
        return this.socksCmdSender.send(this.proxySocket, SocksCommand.CONNECT, address, 5);
    }

    @Override
    public CommandReplyMessage requestBind(String host, int port) throws SocksException, IOException {
        return this.socksCmdSender.send(this.proxySocket, SocksCommand.BIND, host, port, 5);
    }

    @Override
    public CommandReplyMessage requestBind(InetAddress inetAddress, int port) throws SocksException, IOException {
        return this.socksCmdSender.send(this.proxySocket, SocksCommand.BIND, inetAddress, port, 5);
    }

    @Override
    public Socket accept() throws SocksException, IOException {
        CommandReplyMessage messge = this.socksCmdSender.checkServerReply(this.proxySocket.getInputStream());
        logger.debug("accept a connection from:{}", (Object)messge.getSocketAddress());
        return this.proxySocket;
    }

    @Override
    public CommandReplyMessage requestUdpAssociate(String host, int port) throws SocksException, IOException {
        return this.socksCmdSender.send(this.proxySocket, SocksCommand.UDP_ASSOCIATE, new InetSocketAddress(host, port), 5);
    }

    @Override
    public CommandReplyMessage requestUdpAssociate(InetAddress address, int port) throws SocksException, IOException {
        return this.socksCmdSender.send(this.proxySocket, SocksCommand.UDP_ASSOCIATE, new InetSocketAddress(address, port), 5);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public Socks5 setPort(int port) {
        this.port = port;
        return this;
    }

    @Override
    public Socket getProxySocket() {
        return this.proxySocket;
    }

    @Override
    public Socks5 setProxySocket(Socket proxySocket) {
        this.proxySocket = proxySocket;
        return this;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.proxySocket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.proxySocket.getOutputStream();
    }

    @Override
    public List<SocksMethod> getAcceptableMethods() {
        return this.acceptableMethods;
    }

    @Override
    public Socks5 setAcceptableMethods(List<SocksMethod> acceptableMethods) {
        this.acceptableMethods = acceptableMethods;
        SocksMethodRegistry.overWriteRegistry(acceptableMethods);
        return this;
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public Socks5 setCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Override
    public SocksMethodRequester getSocksMethodRequester() {
        return this.socksMethodRequester;
    }

    @Override
    public Socks5 setSocksMethodRequester(SocksMethodRequester requester) {
        this.socksMethodRequester = requester;
        return this;
    }

    @Override
    public SocksProxy copy() {
        Socks5 socks5 = new Socks5(this.inetAddress, this.port);
        ((Socks5)socks5.setAcceptableMethods((List)this.acceptableMethods)).setAlwaysResolveAddressLocally(this.alwaysResolveAddressLocally).setCredentials(this.credentials).setSocksMethodRequester(this.socksMethodRequester).setChainProxy(this.chainProxy);
        return socks5;
    }

    @Override
    public SocksProxy copyWithoutChainProxy() {
        return this.copy().setChainProxy(null);
    }

    @Override
    public int getSocksVersion() {
        return 5;
    }

    @Override
    public SocksProxy getChainProxy() {
        return this.chainProxy;
    }

    @Override
    public SocksProxy setChainProxy(SocksProxy chainProxy) {
        this.chainProxy = chainProxy;
        return this;
    }

    @Override
    public Socks5 setHost(String host) throws UnknownHostException {
        this.inetAddress = InetAddress.getByName(host);
        return this;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public Socks5 setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
        return this;
    }

    public String toString() {
        StringBuilder stringBuffer = new StringBuilder("[SOCKS5:");
        stringBuffer.append(new InetSocketAddress(this.inetAddress, this.port)).append("]");
        if (this.getChainProxy() != null) {
            return stringBuffer.append(" --> ").append(this.getChainProxy().toString()).toString();
        }
        return stringBuffer.toString();
    }

    @Override
    public Socket createProxySocket(InetAddress address, int port) throws IOException {
        return new Socket(address, port);
    }

    @Override
    public Socket createProxySocket() throws IOException {
        return new Socket();
    }

    public boolean isAlwaysResolveAddressLocally() {
        return this.alwaysResolveAddressLocally;
    }

    public Socks5 setAlwaysResolveAddressLocally(boolean alwaysResolveAddressLocally) {
        this.alwaysResolveAddressLocally = alwaysResolveAddressLocally;
        return this;
    }
}

