/*
 * Decompiled with CFR 0.152.
 */
package sockslib.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.client.CommandReplyMessage;
import sockslib.client.Socks5;
import sockslib.client.SocksProxy;
import sockslib.common.Socks5DatagramPacketHandler;
import sockslib.common.SocksException;

public class Socks5DatagramSocket
extends DatagramSocket {
    protected static final Logger logger = LoggerFactory.getLogger(Socks5DatagramSocket.class);
    private SocksProxy proxy;
    private InetAddress relayServerInetAddress;
    private int relayServerPort;
    private Socks5DatagramPacketHandler datagramPacketHandler = new Socks5DatagramPacketHandler();

    public Socks5DatagramSocket(SocksProxy proxy) throws SocksException, IOException {
        this.proxy = proxy.copy();
        if (this.proxy.getChainProxy() != null) {
            throw new SocksException("Proxy chain not support UDP ASSOCIATE");
        }
        if (!(this.proxy instanceof Socks5)) {
            throw new SocksException("Only SOCKS5 protocol support UDP ASSOCIATE");
        }
        this.proxy.buildConnection();
        CommandReplyMessage message = this.proxy.requestUdpAssociate(this.getLocalAddress(), this.getLocalPort());
        logger.debug("build datagram socket at[{}:{}]", (Object)this.getLocalAddress(), (Object)this.getLocalPort());
        this.relayServerInetAddress = message.getIp();
        this.relayServerPort = message.getPort();
        logger.info("relay server's address[{}:{}]", (Object)this.relayServerInetAddress, (Object)this.relayServerPort);
    }

    @Override
    public void send(DatagramPacket packet) throws SocksException, IOException {
        super.send(this.datagramPacketHandler.encapsulate(packet, new InetSocketAddress(this.relayServerInetAddress, this.relayServerPort)));
    }

    @Override
    public synchronized void receive(DatagramPacket packet) throws SocksException, IOException {
        super.receive(packet);
        this.datagramPacketHandler.decapsulate(packet);
    }

    @Override
    public void close() {
        super.close();
        try {
            if (!this.proxy.getProxySocket().isClosed()) {
                this.proxy.getProxySocket().close();
            }
        }
        catch (IOException e10) {
            logger.error(e10.getMessage(), e10);
        }
    }

    public SocksProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(SocksProxy proxy) {
        this.proxy = proxy;
    }
}

