/*
 * Decompiled with CFR 0.152.
 */
package sockslib.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.client.CommandReplyMessage;
import sockslib.client.SocksProxy;
import sockslib.common.SocksException;

public class SocksServerSocket
extends ServerSocket {
    protected static final Logger logger = LoggerFactory.getLogger(SocksServerSocket.class);
    private SocksProxy proxy;
    private InetAddress incomeAddress;
    private int incomePort;
    private InetAddress bindAddress;
    private int bindPort;
    private boolean alreadyAccepted = false;

    public SocksServerSocket(SocksProxy proxy, InetAddress inetAddress, int port) throws SocksException, IOException {
        this.proxy = proxy.copy();
        this.incomePort = port;
        this.incomeAddress = inetAddress;
        this.proxy.buildConnection();
        CommandReplyMessage replyMesasge = this.proxy.requestBind(this.incomeAddress, this.incomePort);
        this.bindAddress = replyMesasge.getIp();
        this.bindPort = replyMesasge.getPort();
        logger.debug("Bind at {}:{}", (Object)this.bindAddress, (Object)this.bindPort);
    }

    @Override
    public synchronized Socket accept() throws SocksException, IOException {
        if (this.alreadyAccepted) {
            throw new SocksException("SOCKS4/SOCKS5 protocol only allows one income connection");
        }
        this.alreadyAccepted = true;
        return this.proxy.accept();
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public void setBindPort(int bindPort) {
        this.bindPort = bindPort;
    }

    public SocketAddress getBindSocketAddress() {
        return new InetSocketAddress(this.bindAddress, this.bindPort);
    }
}

