/*
 * Decompiled with CFR 0.152.
 */
package sockslib.client;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.client.SocksProxy;
import sockslib.common.SocksException;

public class SocksSocket
extends Socket {
    protected static final Logger logger = LoggerFactory.getLogger(SocksSocket.class);
    private SocksProxy proxy;
    private String remoteServerHost;
    private int remoteServerPort;
    private Socket proxySocket;

    public SocksSocket(SocksProxy proxy, String remoteServerHost, int remoteServerPort) throws SocksException, IOException {
        this.proxy = Preconditions.checkNotNull(proxy, "Argument [proxy] may not be null").copy();
        this.proxy.setProxySocket(this.proxySocket);
        this.remoteServerHost = Preconditions.checkNotNull(remoteServerHost, "Argument [remoteServerHost] may not be null");
        this.remoteServerPort = remoteServerPort;
        this.proxy.buildConnection();
        this.proxySocket = this.proxy.getProxySocket();
        this.initProxyChain();
        this.proxy.requestConnect(remoteServerHost, remoteServerPort);
    }

    public SocksSocket(SocksProxy proxy, InetAddress address, int port) throws SocksException, IOException {
        this(proxy, new InetSocketAddress(address, port));
    }

    public SocksSocket(SocksProxy proxy, SocketAddress socketAddress) throws SocksException, IOException {
        Preconditions.checkNotNull(proxy, "Argument [proxy] may not be null");
        Preconditions.checkNotNull(socketAddress, "Argument [socketAddress] may not be null");
        Preconditions.checkArgument(socketAddress instanceof InetSocketAddress, "Unsupported address type");
        InetSocketAddress address = (InetSocketAddress)socketAddress;
        this.proxy = proxy.copy();
        this.remoteServerHost = address.getHostString();
        this.remoteServerPort = address.getPort();
        this.proxy.buildConnection();
        this.proxySocket = this.proxy.getProxySocket();
        this.initProxyChain();
        this.proxy.requestConnect(address.getAddress(), address.getPort());
    }

    public SocksSocket(SocksProxy proxy) throws IOException {
        this(proxy, proxy.createProxySocket());
    }

    public SocksSocket(SocksProxy proxy, Socket proxySocket) {
        Preconditions.checkNotNull(proxy, "Argument [proxy] may not be null");
        Preconditions.checkNotNull(proxySocket, "Argument [proxySocket] may not be null");
        Preconditions.checkArgument(!proxySocket.isConnected(), "Proxy socket should be unconnected");
        this.proxySocket = proxySocket;
        this.proxy = proxy.copy();
        this.proxy.setProxySocket(proxySocket);
    }

    private void initProxyChain() throws SocketException, IOException {
        ArrayList<SocksProxy> proxyChain = new ArrayList<SocksProxy>();
        SocksProxy temp = this.proxy;
        while (temp.getChainProxy() != null) {
            temp.getChainProxy().setProxySocket(this.proxySocket);
            proxyChain.add(temp.getChainProxy());
            temp = temp.getChainProxy();
        }
        logger.debug("Proxy chain has:{} proxy", (Object)proxyChain.size());
        if (proxyChain.size() > 0) {
            SocksProxy pre = this.proxy;
            for (int i10 = 0; i10 < proxyChain.size(); ++i10) {
                SocksProxy chain = (SocksProxy)proxyChain.get(i10);
                pre.requestConnect(chain.getInetAddress(), chain.getPort());
                this.proxy.getChainProxy().buildConnection();
                pre = chain;
            }
        }
    }

    public void connect(String host, int port) throws SocksException, IOException {
        this.remoteServerHost = Preconditions.checkNotNull(host, "Argument [host] may not be null");
        this.remoteServerPort = Preconditions.checkNotNull(port, "Argument [port] may not be null");
        this.proxy.buildConnection();
        this.initProxyChain();
        this.proxy.requestConnect(this.remoteServerHost, this.remoteServerPort);
    }

    @Override
    public void connect(SocketAddress endpoint) throws SocksException, IOException {
        this.connect(endpoint, 0);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws SocksException, IOException {
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        this.remoteServerHost = ((InetSocketAddress)endpoint).getHostName();
        this.remoteServerPort = ((InetSocketAddress)endpoint).getPort();
        this.proxy.getProxySocket().setSoTimeout(timeout);
        this.proxy.buildConnection();
        this.initProxyChain();
        this.proxy.requestConnect(endpoint);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.proxy.getProxySocket().getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.proxy.getProxySocket().getOutputStream();
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this.proxy.getProxySocket().bind(bindpoint);
    }

    @Override
    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.remoteServerHost);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.proxy.getProxySocket().getLocalAddress();
    }

    @Override
    public int getPort() {
        return this.remoteServerPort;
    }

    @Override
    public int getLocalPort() {
        return this.proxy.getProxySocket().getLocalPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.proxy.getProxySocket().getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.proxy.getProxySocket().getLocalSocketAddress();
    }

    @Override
    public SocketChannel getChannel() {
        return this.proxy.getProxySocket().getChannel();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.proxy.getProxySocket().getTcpNoDelay();
    }

    @Override
    public void setTcpNoDelay(boolean on2) throws SocketException {
        this.proxy.getProxySocket().setTcpNoDelay(on2);
    }

    @Override
    public void setSoLinger(boolean on2, int linger) throws SocketException {
        this.proxy.getProxySocket().setSoLinger(on2, linger);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.proxy.getProxySocket().getSoLinger();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.proxy.getProxySocket().sendUrgentData(data);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.proxy.getProxySocket().getOOBInline();
    }

    @Override
    public void setOOBInline(boolean on2) throws SocketException {
        this.proxy.getProxySocket().setOOBInline(on2);
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return this.proxy.getProxySocket().getSoTimeout();
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.proxy.getProxySocket().setSoTimeout(timeout);
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        return this.proxy.getProxySocket().getSendBufferSize();
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.proxy.getProxySocket().setSendBufferSize(size);
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.proxy.getProxySocket().getReceiveBufferSize();
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.proxy.getProxySocket().setReceiveBufferSize(size);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.proxy.getProxySocket().getKeepAlive();
    }

    @Override
    public void setKeepAlive(boolean on2) throws SocketException {
        this.proxy.getProxySocket().setKeepAlive(on2);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.proxy.getProxySocket().getTrafficClass();
    }

    @Override
    public void setTrafficClass(int tc2) throws SocketException {
        this.proxy.getProxySocket().setTrafficClass(tc2);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.proxy.getProxySocket().getReuseAddress();
    }

    @Override
    public void setReuseAddress(boolean on2) throws SocketException {
        this.proxy.getProxySocket().setReuseAddress(on2);
    }

    @Override
    public synchronized void close() throws IOException {
        this.proxy.getProxySocket().close();
        this.proxy.setProxySocket(null);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.proxy.getProxySocket().shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.proxy.getProxySocket().shutdownOutput();
    }

    @Override
    public boolean isConnected() {
        return this.proxy.getProxySocket().isConnected();
    }

    @Override
    public boolean isBound() {
        return this.proxy.getProxySocket().isBound();
    }

    @Override
    public boolean isClosed() {
        return this.proxy.getProxySocket().isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.proxy.getProxySocket().isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.proxy.getProxySocket().isOutputShutdown();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.proxy.getProxySocket().setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    public Socket getProxySocket() {
        return this.proxy.getProxySocket();
    }
}

