/*
 * Decompiled with CFR 0.152.
 */
package sockslib.common;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sockslib.common.IPRange;
import sockslib.utils.UnsignedByte;

public class IP
implements Comparable<IP>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long value;
    private final int a;
    private final int b;
    private final int c;
    private final int d;

    public IP(int a10, int b10, int c10, int d10) {
        Preconditions.checkArgument(this.checkRange(a10) && this.checkRange(b10) && this.checkRange(c10) && this.checkRange(d10), "Each number of IP must in 0 ~ 255");
        this.a = a10;
        this.b = b10;
        this.c = c10;
        this.d = d10;
        this.value = this.toLong();
    }

    public IP(long ip2) {
        Preconditions.checkArgument(ip2 <= 0xFFFFFFFFL && ip2 >= 0L, "Invalid IP");
        this.value = ip2;
        this.a = (int)(ip2 >>> 24);
        this.b = (int)((ip2 & 0xFFFFFFL) >>> 16);
        this.c = (int)((ip2 & 0xFFFFL) >>> 8);
        this.d = (int)(ip2 & 0xFFL);
    }

    public IP(byte[] address) {
        this.a = UnsignedByte.toInt(address[0]);
        this.b = UnsignedByte.toInt(address[1]);
        this.c = UnsignedByte.toInt(address[2]);
        this.d = UnsignedByte.toInt(address[3]);
        this.value = this.toLong();
    }

    public static IP parseFromString(String ip2) {
        String regex = "\\s*(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\s*";
        Pattern pattern = Pattern.compile(regex);
        Matcher m10 = pattern.matcher(ip2);
        Preconditions.checkArgument(m10.find(), "IP string should match the regex:%s", regex);
        int a10 = Integer.parseInt(m10.group(1));
        int b10 = Integer.parseInt(m10.group(2));
        int c10 = Integer.parseInt(m10.group(3));
        int d10 = Integer.parseInt(m10.group(4));
        return new IP(a10, b10, c10, d10);
    }

    public static IP MAX_IP() {
        return new IP(0xFFFFFFFFL);
    }

    public static IP MIN_IP() {
        return new IP(0L);
    }

    public static boolean isValid(String ip2) {
        try {
            IP.parseFromString(ip2);
        }
        catch (Exception e10) {
            return false;
        }
        return true;
    }

    public int getA() {
        return this.a;
    }

    public int getB() {
        return this.b;
    }

    public int getC() {
        return this.c;
    }

    public int getD() {
        return this.d;
    }

    public IP nextIP() {
        return new IP(this.value + 1L);
    }

    public IP preIP() {
        return new IP(this.value - 1L);
    }

    public boolean isLocalIP() {
        return IPRange.AClassLocalIPRange().contains(this) || IPRange.BClassLocalIPRange().contains(this) || IPRange.CClassLocalIPRange().contains(this);
    }

    public boolean isUseInInternet() {
        return !this.isLocalIP();
    }

    public long toLong() {
        long a10 = this.a;
        long b10 = this.b;
        long c10 = this.c;
        long d10 = this.d;
        return a10 << 24 | b10 << 16 | c10 << 8 | d10;
    }

    @Override
    public int compareTo(IP ip2) {
        return this.value > ip2.getValue() ? 1 : (this.value < ip2.getValue() ? -1 : 0);
    }

    public long getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("%s.%s.%s.%s", this.a, this.b, this.c, this.d);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IP) {
            IP ip2 = (IP)obj;
            if (this.getValue() == ip2.getValue()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Hashing.md5().newHasher().putInt(this.a).putChar('.').putInt(this.b).putChar('.').putInt(this.c).putChar('.').putInt(this.d).hash().hashCode();
    }

    private boolean checkRange(int num) {
        return num >= 0 && num <= 255;
    }
}

