/*
 * Decompiled with CFR 0.152.
 */
package sockslib.common;

import java.util.Iterator;
import sockslib.common.IP;
import sockslib.common.IPRange;

public class IPIterator
implements Iterator<IP> {
    private IPRange range;
    private IP currentIP;
    private boolean start = true;

    public IPIterator(IPRange range) {
        this.range = range;
        this.currentIP = range.getStartIP();
    }

    public IPIterator(IP startIP, IP endIP) {
        this.range = new IPRange(startIP, endIP);
        this.currentIP = startIP;
    }

    @Override
    public boolean hasNext() {
        if (this.start) {
            return true;
        }
        return this.range.contains(this.currentIP.nextIP());
    }

    @Override
    public IP next() {
        if (this.start) {
            this.start = false;
            return this.currentIP;
        }
        this.currentIP = this.currentIP.nextIP();
        return this.currentIP;
    }

    @Override
    public void remove() {
    }
}

