/*
 * Decompiled with CFR 0.152.
 */
package sockslib.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStore;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.common.KeyStoreInfo;
import sockslib.common.SSLConfigurationException;
import sockslib.utils.PathUtil;

public class SSLConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SSLConfiguration.class);
    private KeyStoreInfo keyStoreInfo;
    private KeyStoreInfo trustKeyStoreInfo;
    private boolean needClientAuth = false;

    public SSLConfiguration(KeyStoreInfo keyStoreInfo, KeyStoreInfo trustKeyStoreInfo) {
        this(keyStoreInfo, trustKeyStoreInfo, false);
    }

    public SSLConfiguration(@Nullable KeyStoreInfo keyStoreInfo, @Nullable KeyStoreInfo trustKeyStoreInfo, boolean clientAuth) {
        this.keyStoreInfo = keyStoreInfo;
        this.trustKeyStoreInfo = trustKeyStoreInfo;
        this.needClientAuth = clientAuth;
    }

    public static SSLConfiguration parse(String configuration) {
        String[] strings = configuration.split(",");
        if (strings.length == 2) {
            KeyStoreInfo keyStoreInfo = new KeyStoreInfo(strings[0], strings[1]);
            return new SSLConfiguration(keyStoreInfo, null);
        }
        if (strings.length == 4) {
            KeyStoreInfo keyStoreInfo = new KeyStoreInfo(strings[0], strings[1]);
            KeyStoreInfo trustKeyStoreInfo = new KeyStoreInfo(strings[2], strings[3]);
            return new SSLConfiguration(keyStoreInfo, trustKeyStoreInfo);
        }
        if (strings.length == 5) {
            KeyStoreInfo keyStoreInfo = new KeyStoreInfo(strings[0], strings[1]);
            KeyStoreInfo trustKeyStoreInfo = new KeyStoreInfo(strings[2], strings[3]);
            return new SSLConfiguration(keyStoreInfo, trustKeyStoreInfo, strings[4].equals("true"));
        }
        return null;
    }

    public static SSLConfiguration load(String filePath) throws FileNotFoundException, IOException {
        Preconditions.checkNotNull(filePath, "Argument [filePath] may not be null");
        logger.debug("load SSL configuration file:{}", (Object)filePath);
        KeyStoreInfo keyStoreInfo = null;
        KeyStoreInfo trustKeyStoreInfo = null;
        Properties properties = new Properties();
        properties.load(new FileInputStream(filePath));
        String keystorePath = PathUtil.getAbstractPath(properties.getProperty("ssl.keystore.location"));
        String password = properties.getProperty("ssl.keystore.password");
        String type = properties.getProperty("ssl.keystore.type", "JSK");
        String trustKeystorePath = PathUtil.getAbstractPath(properties.getProperty("ssl.trustStore.location"));
        String trustPassword = properties.getProperty("ssl.trustStore.password");
        String trustType = properties.getProperty("ssl.trustStore.type", "JSK");
        if (!Strings.isNullOrEmpty(keystorePath)) {
            keyStoreInfo = new KeyStoreInfo(keystorePath, password, type);
        }
        if (!Strings.isNullOrEmpty(trustKeystorePath)) {
            trustKeyStoreInfo = new KeyStoreInfo(trustKeystorePath, trustPassword, trustType);
        }
        String clientAuthValue = properties.getProperty("ssl.client.auth", "false");
        boolean clientAuth = false;
        if (clientAuthValue.equalsIgnoreCase("true")) {
            clientAuth = true;
        }
        return new SSLConfiguration(keyStoreInfo, trustKeyStoreInfo, clientAuth);
    }

    public static SSLConfiguration loadClassPath(String filePath) throws FileNotFoundException, IOException {
        URL url;
        Preconditions.checkNotNull(filePath, "Argument [filePath] may not be null");
        if (!filePath.startsWith(File.separator)) {
            filePath = File.separator + filePath;
        }
        if ((url = SSLConfiguration.class.getResource(filePath)) == null) {
            throw new FileNotFoundException("classpath:" + filePath);
        }
        String path = url.getPath();
        return SSLConfiguration.load(path);
    }

    public SSLSocketFactory getSSLSocketFactory() throws SSLConfigurationException {
        Preconditions.checkNotNull(this.trustKeyStoreInfo, "trustKeyStoreInfo may not be null");
        KeyStore keyStore = null;
        KeyStore trustKeyStore = null;
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustKeyStore = KeyStore.getInstance(this.trustKeyStoreInfo.getType());
            trustKeyStore.load(new FileInputStream(this.trustKeyStoreInfo.getKeyStorePath()), this.trustKeyStoreInfo.getPassword().toCharArray());
            trustManagerFactory.init(trustKeyStore);
            if (this.keyStoreInfo != null && this.keyStoreInfo.getKeyStorePath() != null) {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                keyStore = KeyStore.getInstance(this.keyStoreInfo.getType());
                keyStore.load(new FileInputStream(this.keyStoreInfo.getKeyStorePath()), this.keyStoreInfo.getPassword().toCharArray());
                keyManagerFactory.init(keyStore, this.keyStoreInfo.getPassword().toCharArray());
                context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            } else {
                context.init(null, trustManagerFactory.getTrustManagers(), null);
            }
            if (keyStore != null) {
                logger.info("SSL: Key store:{}", (Object)this.keyStoreInfo.getKeyStorePath());
            }
            logger.info("SSL: Trust key store:{}", (Object)this.trustKeyStoreInfo.getKeyStorePath());
            return context.getSocketFactory();
        }
        catch (Exception e10) {
            logger.error(e10.getMessage(), e10);
            throw new SSLConfigurationException(e10.getMessage());
        }
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() throws SSLConfigurationException {
        Preconditions.checkNotNull(this.keyStoreInfo, "keyStoreInfo may not be null");
        String KEY_STORE_PASSWORD = this.getKeyStoreInfo().getPassword();
        String KEY_STORE_PATH = this.getKeyStoreInfo().getKeyStorePath();
        KeyStore keyStore = null;
        KeyStore trustKeyStore = null;
        try {
            SSLContext ctx = SSLContext.getInstance("SSL");
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(KEY_STORE_PATH), KEY_STORE_PASSWORD.toCharArray());
            keyManagerFactory.init(keyStore, KEY_STORE_PASSWORD.toCharArray());
            if (this.needClientAuth && this.trustKeyStoreInfo != null) {
                String TRUST_KEY_STORE_PATH = this.getTrustKeyStoreInfo().getKeyStorePath();
                String TRUST_KEY_STORE_PASSWORD = this.getTrustKeyStoreInfo().getPassword();
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                trustKeyStore = KeyStore.getInstance("JKS");
                trustKeyStore.load(new FileInputStream(TRUST_KEY_STORE_PATH), TRUST_KEY_STORE_PASSWORD.toCharArray());
                trustManagerFactory.init(trustKeyStore);
                ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            } else {
                ctx.init(keyManagerFactory.getKeyManagers(), null, null);
            }
            logger.info("SSL: Key store:{}", (Object)this.keyStoreInfo.getKeyStorePath());
            if (trustKeyStore != null) {
                logger.info("SSL: Trust key store:{}", (Object)this.trustKeyStoreInfo.getKeyStorePath());
            }
            logger.info("SSL: Client authentication:{}", (Object)this.needClientAuth);
            return ctx.getServerSocketFactory();
        }
        catch (Exception e10) {
            throw new SSLConfigurationException(e10.getMessage());
        }
    }

    public KeyStoreInfo getKeyStoreInfo() {
        return this.keyStoreInfo;
    }

    public void setKeyStoreInfo(KeyStoreInfo keyStoreInfo) {
        this.keyStoreInfo = keyStoreInfo;
    }

    public KeyStoreInfo getTrustKeyStoreInfo() {
        return this.trustKeyStoreInfo;
    }

    public void setTrustKeyStoreInfo(KeyStoreInfo trustKeyStoreInfo) {
        this.trustKeyStoreInfo = trustKeyStoreInfo;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }
}

