/*
 * Decompiled with CFR 0.152.
 */
package sockslib.common;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import java.io.Serializable;
import java.security.Principal;

public class Socks5UserPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 1L;
    private String username;

    public Socks5UserPrincipal(String username) {
        this.username = Preconditions.checkNotNull(username, "Argument [username] may not be null");
    }

    @Override
    public String getName() {
        return this.username;
    }

    @Override
    public int hashCode() {
        return Hashing.md5().newHasher().putString(this.username, Charsets.UTF_8).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Socks5UserPrincipal) {
            Socks5UserPrincipal that = (Socks5UserPrincipal)obj;
            if (this.username.equals(that.username)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("Principal[%s]", this.username);
    }
}

