/*
 * Decompiled with CFR 0.152.
 */
package sockslib.common;

import com.google.common.base.Preconditions;
import java.security.Principal;
import sockslib.common.Credentials;
import sockslib.common.Socks5UserPrincipal;

public class UsernamePasswordCredentials
implements Credentials {
    private Socks5UserPrincipal principal;
    private String password;

    public UsernamePasswordCredentials(String username, String password) {
        this.principal = new Socks5UserPrincipal(Preconditions.checkNotNull(username, "Username may not be null"));
        this.password = Preconditions.checkNotNull(password, "Argument [password] may not be null");
    }

    @Override
    public Principal getUserPrincipal() {
        return this.principal;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials that = (UsernamePasswordCredentials)obj;
            if (this.principal.equals(that.principal)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.principal.hashCode();
    }

    public String toString() {
        return this.principal.toString();
    }
}

