/*
 * Decompiled with CFR 0.152.
 */
package sockslib.common.methods;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.common.methods.SocksMethod;

public class SocksMethodRegistry {
    private static final Logger logger = LoggerFactory.getLogger(SocksMethodRegistry.class);
    private static final Map<Byte, SocksMethod> methods = new HashMap<Byte, SocksMethod>();

    private SocksMethodRegistry() {
    }

    public static void putMethod(SocksMethod socksMethod) {
        Preconditions.checkNotNull(socksMethod, "Argument [socksMethod] may not be null");
        logger.debug("Register {}[{}]", (Object)socksMethod.getMethodName(), (Object)socksMethod.getByte());
        methods.put((byte)socksMethod.getByte(), socksMethod);
    }

    public static void overWriteRegistry(List<SocksMethod> socksMethods) {
        Preconditions.checkNotNull(socksMethods, "Argument [socksMethods] may not be null");
        for (SocksMethod socksMethod : socksMethods) {
            SocksMethodRegistry.putMethod(socksMethod);
        }
    }

    public static SocksMethod getByByte(byte b10) {
        return methods.get(b10);
    }
}

