/*
 * Decompiled with CFR 0.152.
 */
package sockslib.common.net;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import sockslib.common.net.InputStreamMonitor;

public class MonitorInputStreamWrapper
extends InputStream {
    private InputStream originalInputStream;
    private List<InputStreamMonitor> monitors;

    public MonitorInputStreamWrapper(InputStream inputStream) {
        this.originalInputStream = inputStream;
    }

    public MonitorInputStreamWrapper(InputStream inputStream, InputStreamMonitor ... monitors) {
        this.originalInputStream = Preconditions.checkNotNull(inputStream);
        this.monitors = new ArrayList<InputStreamMonitor>(monitors.length);
        Collections.addAll(this.monitors, monitors);
    }

    public MonitorInputStreamWrapper(InputStream inputStream, List<InputStreamMonitor> monitors) {
        this.originalInputStream = Preconditions.checkNotNull(inputStream);
        this.monitors = Preconditions.checkNotNull(monitors);
    }

    public static InputStream wrap(InputStream inputStream, InputStreamMonitor ... monitors) {
        return new MonitorInputStreamWrapper(inputStream, monitors);
    }

    public static InputStream wrap(InputStream inputStream, List<InputStreamMonitor> monitors) {
        return new MonitorInputStreamWrapper(inputStream, monitors);
    }

    public InputStream getOriginalInputStream() {
        return this.originalInputStream;
    }

    public MonitorInputStreamWrapper addMonitor(InputStreamMonitor monitor) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<InputStreamMonitor>(1);
        }
        this.monitors.add(monitor);
        return this;
    }

    public MonitorInputStreamWrapper removeMonitor(InputStreamMonitor monitor) {
        if (this.monitors != null) {
            this.monitors.remove(monitor);
        }
        return this;
    }

    @Override
    public int read() throws IOException {
        int b10 = this.originalInputStream.read();
        byte[] array = new byte[]{(byte)b10};
        this.informMonitor(array);
        return b10;
    }

    public List<InputStreamMonitor> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(List<InputStreamMonitor> monitors) {
        this.monitors = Preconditions.checkNotNull(monitors);
    }

    @Override
    public void close() throws IOException {
        this.originalInputStream.close();
    }

    @Override
    public int available() throws IOException {
        return this.originalInputStream.available();
    }

    @Override
    public long skip(long n10) throws IOException {
        return this.originalInputStream.skip(n10);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.originalInputStream.reset();
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.originalInputStream.mark(readLimit);
    }

    @Override
    public boolean markSupported() {
        return this.originalInputStream.markSupported();
    }

    @Override
    public int read(byte[] b10) throws IOException {
        int length = this.originalInputStream.read(b10);
        if (length > 0) {
            this.informMonitor(b10, 0, length);
        }
        return length;
    }

    @Override
    public int read(byte[] b10, int off, int len) throws IOException {
        int length = this.originalInputStream.read(b10, off, len);
        if (length > 0) {
            this.informMonitor(b10, off, length);
        }
        return length;
    }

    private void informMonitor(byte[] bytes) {
        if (this.monitors != null) {
            for (InputStreamMonitor monitor : this.monitors) {
                monitor.onRead(bytes);
            }
        }
    }

    private void informMonitor(byte[] bytes, int off, int len) {
        if (this.monitors != null) {
            for (InputStreamMonitor monitor : this.monitors) {
                monitor.onRead(Arrays.copyOfRange(bytes, off, off + len));
            }
        }
    }
}

