/*
 * Decompiled with CFR 0.152.
 */
package sockslib.common.net;

import java.net.DatagramPacket;
import sockslib.common.net.DatagramSocketMonitor;
import sockslib.common.net.SocketMonitor;

public class NetworkMonitor
implements SocketMonitor,
DatagramSocketMonitor {
    private long receiveTCP = 0L;
    private long receiveUDP = 0L;
    private long sendTCP = 0L;
    private long sendUDP = 0L;

    @Override
    public void onRead(byte[] bytes) {
        this.receiveTCP += (long)bytes.length;
    }

    @Override
    public void onWrite(byte[] bytes) {
        this.sendTCP += (long)bytes.length;
    }

    @Override
    public void onSend(DatagramPacket datagramPacket) {
        this.sendUDP += (long)datagramPacket.getLength();
    }

    @Override
    public void onReceive(DatagramPacket datagramPacket) {
        this.receiveUDP += (long)datagramPacket.getLength();
    }

    public long getTotalReceive() {
        return this.receiveTCP + this.receiveUDP;
    }

    public long getTotalSend() {
        return this.sendTCP + this.sendUDP;
    }

    public long getTotal() {
        return this.getTotalReceive() + this.getTotalSend();
    }

    public long getReceiveTCP() {
        return this.receiveTCP;
    }

    public long getReceiveUDP() {
        return this.receiveUDP;
    }

    public long getSendTCP() {
        return this.sendTCP;
    }

    public long getSendUDP() {
        return this.sendUDP;
    }

    public String toString() {
        return "NetworkMonitor{sendTCP=" + this.sendTCP + ", receiveTCP=" + this.receiveTCP + ", sendUDP=" + this.sendUDP + ", receiveUDP=" + this.receiveUDP + '}';
    }
}

