/*
 * Decompiled with CFR 0.152.
 */
package sockslib.quickstart;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.utils.Arguments;
import sockslib.utils.Timer;

public class TCPTimeServer
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(TCPTimeServer.class);
    private static final int DEFAULT_PORT = 5051;
    private String[] args;
    private boolean stop = false;
    private Thread thread;
    private ServerSocket server;

    public static void main(@Nullable String[] args) {
        Timer.open();
        TCPTimeServer server = new TCPTimeServer();
        server.start(args);
    }

    public void start(@Nullable String[] args) {
        this.args = args;
        this.stop = false;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void shutdown() {
        this.stop = true;
        if (this.thread != null) {
            this.thread.interrupt();
        }
        if (this.server != null && this.server.isBound()) {
            try {
                this.server.close();
            }
            catch (IOException e10) {
                logger.error(e10.getMessage(), e10);
            }
        }
    }

    public void showHelp() {
        System.out.println("Usage: [Options]");
        System.out.println("    --port=<val>             UDP server Test port");
        System.out.println("    --always-response=<val>  Server always responses <val> to client");
        System.out.println("    -h or --help             Show help");
    }

    @Override
    public void run() {
        int port = 5051;
        Object socksProxy = null;
        String alwaysResponse = null;
        Object proxyHost = null;
        Object proxyUsername = null;
        Object proxyPassword = null;
        if (this.args != null) {
            for (String arg : this.args) {
                if (arg.equals("-h") || arg.equals("--help")) {
                    this.showHelp();
                    System.exit(0);
                    continue;
                }
                if (arg.startsWith("--port=")) {
                    try {
                        port = Arguments.intValueOf(arg);
                    }
                    catch (NumberFormatException e10) {
                        logger.error("Value of [--port] should be a number");
                        System.exit(-1);
                    }
                    continue;
                }
                if (arg.startsWith("--always-response=")) {
                    alwaysResponse = Arguments.valueOf(arg);
                    continue;
                }
                logger.error("Unknown argument [{}]", (Object)arg);
                return;
            }
        }
        try {
            this.server = new ServerSocket(port);
            logger.info("TCP time server created at {}", (Object)this.server.getInetAddress(), (Object)port);
            while (!this.stop) {
                byte b10;
                Socket socket = this.server.accept();
                InputStream inputStream = socket.getInputStream();
                OutputStream outputStream = socket.getOutputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((b10 = (byte)inputStream.read()) != -1 && b10 != 10) {
                    byteArrayOutputStream.write(b10);
                }
                byte[] buffer = byteArrayOutputStream.toByteArray();
                String receive = new String(buffer);
                logger.info("Client from {} send:{}", (Object)socket.getRemoteSocketAddress(), (Object)receive);
                if (!receive.equals("shutdown")) {
                    String response = new Date().toString();
                    if (alwaysResponse != null) {
                        response = alwaysResponse;
                    }
                    response = response + "\n";
                    outputStream.write(response.getBytes());
                    outputStream.flush();
                    inputStream.close();
                    outputStream.close();
                    socket.close();
                    continue;
                }
                break;
            }
        }
        catch (IOException e11) {
            logger.error(e11.getMessage(), e11);
        }
    }
}

