/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLServerSocket;
import sockslib.common.SSLConfiguration;
import sockslib.common.SocksException;
import sockslib.server.BasicSocksProxyServer;
import sockslib.server.SocksHandler;

public class SSLSocksProxyServer
extends BasicSocksProxyServer {
    private SSLConfiguration configuration;

    public SSLSocksProxyServer(Class<? extends SocksHandler> socketHandlerClass, ExecutorService executorService, SSLConfiguration configuration) {
        this(socketHandlerClass, 1080, executorService, configuration);
    }

    public SSLSocksProxyServer(Class<? extends SocksHandler> socketHandlerClass, int port, ExecutorService executorService, SSLConfiguration configuration) {
        super(socketHandlerClass, port, executorService);
        this.configuration = configuration;
    }

    public SSLSocksProxyServer(Class<? extends SocksHandler> socketHandlerClass, int port, SSLConfiguration configuration) {
        this(socketHandlerClass, port, Executors.newFixedThreadPool(100), configuration);
    }

    public SSLSocksProxyServer(Class<? extends SocksHandler> socketHandlerClass, SSLConfiguration configuration) {
        this(socketHandlerClass, 1080, Executors.newFixedThreadPool(100), configuration);
    }

    @Override
    protected ServerSocket createServerSocket(int bindPort, InetAddress bindAddr) throws IOException {
        try {
            return this.createSSLServer(bindPort, bindAddr);
        }
        catch (Exception e10) {
            throw new SocksException(e10.getMessage());
        }
    }

    public SSLConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SSLConfiguration configuration) {
        this.configuration = configuration;
    }

    public ServerSocket createSSLServer(int port, InetAddress bindAddr) throws Exception {
        SSLServerSocket serverSocket = (SSLServerSocket)this.configuration.getSSLServerSocketFactory().createServerSocket(port, 50, bindAddr);
        if (this.configuration.isNeedClientAuth()) {
            serverSocket.setNeedClientAuth(true);
        } else {
            serverSocket.setNeedClientAuth(false);
        }
        return serverSocket;
    }
}

