/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server;

import sockslib.common.methods.NoAuthenticationRequiredMethod;
import sockslib.common.methods.UsernamePasswordMethod;
import sockslib.server.BasicSocksProxyServer;
import sockslib.server.Socks5Handler;
import sockslib.server.SocksProxyServer;
import sockslib.server.UsernamePasswordAuthenticator;
import sockslib.server.manager.User;

public class SocksProxyServerFactory {
    private static final int TIMEOUT = 100000;
    private static final int BUFFER_SIZE = 0x500000;
    private static final int DEFAULT_PORT = 1080;

    public static SocksProxyServer newNoAuthenticationServer() {
        return SocksProxyServerFactory.newNoAuthenticationServer(1080);
    }

    public static SocksProxyServer newNoAuthenticationServer(int port) {
        BasicSocksProxyServer proxyServer = new BasicSocksProxyServer(Socks5Handler.class, port);
        proxyServer.setBufferSize(0x500000);
        proxyServer.setTimeout(100000);
        proxyServer.setSupportMethods(new NoAuthenticationRequiredMethod());
        return proxyServer;
    }

    public static SocksProxyServer newUsernamePasswordAuthenticationServer(User ... users) {
        return SocksProxyServerFactory.newUsernamePasswordAuthenticationServer(1080, users);
    }

    public static SocksProxyServer newUsernamePasswordAuthenticationServer(int port, User ... users) {
        BasicSocksProxyServer proxyServer = new BasicSocksProxyServer(Socks5Handler.class, port);
        proxyServer.setBufferSize(0x500000);
        proxyServer.setTimeout(100000);
        UsernamePasswordAuthenticator authenticator = new UsernamePasswordAuthenticator();
        for (User user : users) {
            authenticator.addUser(user.getUsername(), user.getPassword());
        }
        proxyServer.setSupportMethods(new UsernamePasswordMethod(authenticator));
        return proxyServer;
    }
}

