/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.client.SocksProxy;
import sockslib.common.SSLConfiguration;
import sockslib.common.methods.NoAuthenticationRequiredMethod;
import sockslib.common.methods.SocksMethod;
import sockslib.server.BasicSessionManager;
import sockslib.server.BasicSocksProxyServer;
import sockslib.server.SSLSocksProxyServer;
import sockslib.server.SessionManager;
import sockslib.server.Socks5Handler;
import sockslib.server.SocksHandler;
import sockslib.server.SocksProxyServer;
import sockslib.server.listener.PipeInitializer;
import sockslib.server.listener.SessionListener;

public class SocksServerBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SocksServerBuilder.class);
    private static final int DEFAULT_PORT = 1080;
    private Class<? extends SocksHandler> socksHandlerClass;
    private Set<SocksMethod> socksMethods;
    private SocksProxy proxy;
    private int timeout;
    private InetAddress bindAddr;
    private int bindPort = 1080;
    private boolean daemon = false;
    private ExecutorService executorService;
    private SessionManager sessionManager = new BasicSessionManager();
    private SSLConfiguration sslConfiguration;
    private Map<String, SessionListener> sessionListeners = new HashMap<String, SessionListener>();
    private PipeInitializer pipeInitializer;

    private SocksServerBuilder(Class<? extends SocksHandler> socksHandlerClass) {
        this.socksHandlerClass = Preconditions.checkNotNull(socksHandlerClass, "Argument [socksHandlerClass] may not be null");
    }

    public static SocksProxyServer buildAnonymousSocks5Server() {
        return SocksServerBuilder.buildAnonymousSocks5Server(1080);
    }

    public static SocksProxyServer buildAnonymousSocks5Server(int bindPort) {
        return SocksServerBuilder.newSocks5ServerBuilder().setSocksMethods(new NoAuthenticationRequiredMethod()).setBindPort(bindPort).build();
    }

    public static SocksProxyServer buildAnonymousSSLSocks5Server(int bindPort, SSLConfiguration configuration) {
        return SocksServerBuilder.newSocks5ServerBuilder().setSocksMethods(new NoAuthenticationRequiredMethod()).setBindPort(bindPort).useSSL(configuration).build();
    }

    public static SocksProxyServer buildAnonymousSSLSocks5Server(SSLConfiguration configuration) {
        return SocksServerBuilder.buildAnonymousSSLSocks5Server(1080, configuration);
    }

    public static SocksServerBuilder newBuilder(Class<? extends SocksHandler> socksHandlerClass) {
        Preconditions.checkNotNull(socksHandlerClass, "Argument [socksHandlerClass] may not be null");
        return new SocksServerBuilder(socksHandlerClass);
    }

    public static SocksServerBuilder newSocks5ServerBuilder() {
        return new SocksServerBuilder(Socks5Handler.class);
    }

    public SocksServerBuilder addSocksMethods(SocksMethod ... methods) {
        if (this.socksMethods == null) {
            this.socksMethods = new HashSet<SocksMethod>();
        }
        Collections.addAll(this.socksMethods, methods);
        return this;
    }

    public SocksServerBuilder setSocksMethods(SocksMethod ... methods) {
        if (this.socksMethods == null) {
            this.socksMethods = new HashSet<SocksMethod>();
        }
        Collections.addAll(this.socksMethods, methods);
        return this;
    }

    public SocksServerBuilder setPipeInitializer(PipeInitializer pipeInitializer) {
        this.pipeInitializer = pipeInitializer;
        return this;
    }

    public SocksServerBuilder setSocksMethods(Set<SocksMethod> methods) {
        this.socksMethods = Preconditions.checkNotNull(methods, "Argument [methods] may not be null");
        return this;
    }

    public SocksServerBuilder setProxy(SocksProxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public SocksServerBuilder setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public SocksServerBuilder setTimeout(long timeout, TimeUnit timeUnit) {
        this.timeout = (int)timeUnit.toMillis(timeout);
        return this;
    }

    public SocksServerBuilder setBindAddr(InetAddress bindAddr) {
        this.bindAddr = bindAddr;
        return this;
    }

    public SocksServerBuilder setBindPort(int bindPort) {
        this.bindPort = bindPort;
        return this;
    }

    public SocksServerBuilder setExecutorService(ExecutorService executorService) {
        this.executorService = Preconditions.checkNotNull(executorService);
        return this;
    }

    public SocksServerBuilder setDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public SocksServerBuilder setSessionManager(SessionManager sessionManager) {
        this.sessionManager = Preconditions.checkNotNull(sessionManager);
        return this;
    }

    public SocksServerBuilder addSessionListener(String name, SessionListener listener) {
        this.sessionListeners.put(name, listener);
        return this;
    }

    public SocksServerBuilder useSSL(SSLConfiguration sslConfiguration) {
        this.sslConfiguration = sslConfiguration;
        return this;
    }

    public SocksProxyServer build() {
        BasicSocksProxyServer proxyServer = null;
        proxyServer = this.sslConfiguration == null ? new BasicSocksProxyServer(this.socksHandlerClass) : new SSLSocksProxyServer(this.socksHandlerClass, this.sslConfiguration);
        proxyServer.setTimeout(this.timeout);
        proxyServer.setBindAddr(this.bindAddr);
        proxyServer.setBindPort(this.bindPort);
        proxyServer.setDaemon(this.daemon);
        proxyServer.setSessionManager(this.sessionManager);
        proxyServer.setPipeInitializer(this.pipeInitializer);
        if (this.socksMethods == null) {
            this.socksMethods = new HashSet<SocksMethod>();
            this.socksMethods.add(new NoAuthenticationRequiredMethod());
        }
        SocksMethod[] methods = new SocksMethod[this.socksMethods.size()];
        int i10 = 0;
        Iterator<Object> iterator = this.socksMethods.iterator();
        while (iterator.hasNext()) {
            SocksMethod method;
            methods[i10] = method = iterator.next();
            ++i10;
        }
        if (this.executorService != null) {
            proxyServer.setExecutorService(this.executorService);
        }
        proxyServer.setSupportMethods(methods);
        if (this.proxy != null) {
            proxyServer.setProxy(this.proxy);
        }
        for (String name : this.sessionListeners.keySet()) {
            proxyServer.getSessionManager().addSessionListener(name, this.sessionListeners.get(name));
        }
        return proxyServer;
    }
}

