/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.common.Socks5DatagramPacketHandler;
import sockslib.common.net.MonitorDatagramSocketWrapper;
import sockslib.common.net.NetworkMonitor;

public class UDPRelayServer
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(UDPRelayServer.class);
    private Socks5DatagramPacketHandler datagramPacketHandler = new Socks5DatagramPacketHandler();
    private DatagramSocket server;
    private int bufferSize = 0x500000;
    private Thread thread;
    private boolean running = false;
    private InetAddress clientAddress;
    private int clientPort;
    private NetworkMonitor networkMonitor;

    public UDPRelayServer() {
    }

    public UDPRelayServer(InetAddress clientInetAddress, int clientPort) {
        this(new InetSocketAddress(clientInetAddress, clientPort));
    }

    public UDPRelayServer(SocketAddress clientSocketAddress) {
        if (!(clientSocketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Only support java.net.InetSocketAddress");
        }
        this.clientAddress = ((InetSocketAddress)clientSocketAddress).getAddress();
        this.clientPort = ((InetSocketAddress)clientSocketAddress).getPort();
    }

    public SocketAddress start() throws SocketException {
        this.running = true;
        this.server = new DatagramSocket();
        if (this.networkMonitor != null) {
            this.server = new MonitorDatagramSocketWrapper(this.server, this.networkMonitor);
        }
        SocketAddress socketAddress = this.server.getLocalSocketAddress();
        this.thread = new Thread(this);
        this.thread.start();
        return socketAddress;
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            this.thread.interrupt();
            if (!this.server.isClosed()) {
                this.server.close();
            }
        }
    }

    @Override
    public void run() {
        try {
            byte[] buffer = new byte[this.bufferSize];
            while (this.running) {
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                this.server.receive(packet);
                if (this.isFromClient(packet)) {
                    this.datagramPacketHandler.decapsulate(packet);
                    this.server.send(packet);
                    continue;
                }
                packet = this.datagramPacketHandler.encapsulate(packet, new InetSocketAddress(this.clientAddress, this.clientPort));
                this.server.send(packet);
            }
        }
        catch (IOException e10) {
            if (e10.getMessage().equalsIgnoreCase("Socket closed") && !this.running) {
                logger.debug("UDP relay server stopped");
            }
            logger.error(e10.getMessage(), e10);
        }
    }

    protected boolean isFromClient(DatagramPacket packet) {
        if (packet.getPort() == this.clientPort && this.clientAddress.equals(packet.getAddress())) {
            return true;
        }
        return packet.getPort() == this.clientPort && this.clientAddress.getHostAddress().startsWith("127.");
    }

    public DatagramSocket getServer() {
        return this.server;
    }

    public void setServer(DatagramSocket server) {
        this.server = server;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Socks5DatagramPacketHandler getDatagramPacketHandler() {
        return this.datagramPacketHandler;
    }

    public void setDatagramPacketHandler(Socks5DatagramPacketHandler datagramPacketHandler) {
        this.datagramPacketHandler = datagramPacketHandler;
    }

    public InetAddress getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(InetAddress clientAddress) {
        this.clientAddress = clientAddress;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public void setClientPort(int clientPort) {
        this.clientPort = clientPort;
    }

    public boolean isRunning() {
        return this.running;
    }

    public NetworkMonitor getNetworkMonitor() {
        return this.networkMonitor;
    }

    public void setNetworkMonitor(NetworkMonitor networkMonitor) {
        this.networkMonitor = networkMonitor;
    }

    public Thread getServerThread() {
        return this.thread;
    }
}

