/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server;

import sockslib.common.AuthenticationException;
import sockslib.common.Credentials;
import sockslib.common.UsernamePasswordCredentials;
import sockslib.server.Authenticator;
import sockslib.server.Session;
import sockslib.server.manager.MemoryBasedUserManager;
import sockslib.server.manager.User;
import sockslib.server.manager.UserManager;

public class UsernamePasswordAuthenticator
implements Authenticator {
    public static final String USER_KEY = "USER";
    private UserManager userManager = new MemoryBasedUserManager();

    public UsernamePasswordAuthenticator() {
    }

    public UsernamePasswordAuthenticator(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    public void doAuthenticate(Credentials credentials, Session session) throws AuthenticationException {
        User user;
        if (credentials instanceof UsernamePasswordCredentials) {
            String password;
            String username = credentials.getUserPrincipal().getName();
            user = this.userManager.check(username, password = credentials.getPassword());
            if (user == null) {
                this.authenticationFailed(session);
            }
        } else {
            throw new AuthenticationException("Only support Username/Password Authentication");
        }
        this.authenticationSuccess(session, user);
    }

    protected void authenticationSuccess(Session session, User user) {
        session.setAttribute(USER_KEY, user);
    }

    protected void authenticationFailed(Session session) throws AuthenticationException {
        throw new AuthenticationException("Authentication failed, client from " + session.getClientAddress());
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void addUser(String username, String password) {
        this.userManager.addUser(username, password);
    }

    public void deleteUser(String username) {
        this.userManager.delete(username);
    }
}

