/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server.io;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.server.io.Pipe;
import sockslib.server.io.PipeListener;

public class StreamPipe
implements Runnable,
Pipe {
    protected static final Logger logger = LoggerFactory.getLogger(StreamPipe.class);
    private static final int BUFFER_SIZE = 0x500000;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private List<PipeListener> pipeListeners;
    private InputStream source;
    private OutputStream destination;
    private int bufferSize = 0x500000;
    private Thread runningThread;
    private boolean running = false;
    private String name;
    private boolean daemon = false;

    public StreamPipe(InputStream source, OutputStream destination) {
        this(source, destination, null);
    }

    public StreamPipe(InputStream source, OutputStream destination, @Nullable String name) {
        this.source = Preconditions.checkNotNull(source, "Argument [source] may not be null");
        this.destination = Preconditions.checkNotNull(destination, "Argument [destination] may not be null");
        this.pipeListeners = new ArrayList<PipeListener>();
        this.name = name;
    }

    @Override
    public boolean start() {
        if (!this.running) {
            this.running = true;
            this.runningThread = new Thread(this);
            this.runningThread.setDaemon(this.daemon);
            this.runningThread.start();
            for (PipeListener listener : this.pipeListeners) {
                listener.onStart(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean stop() {
        if (this.running) {
            this.running = false;
            if (this.runningThread != null) {
                this.runningThread.interrupt();
            }
            for (int i10 = 0; i10 < this.pipeListeners.size(); ++i10) {
                PipeListener listener = this.pipeListeners.get(i10);
                listener.onStop(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[this.bufferSize];
        while (this.running) {
            int size = this.doTransfer(buffer);
            if (size != -1) continue;
            this.stop();
        }
    }

    protected int doTransfer(byte[] buffer) {
        int length = -1;
        try {
            length = this.source.read(buffer);
            if (length > 0) {
                this.destination.write(buffer, 0, length);
                this.destination.flush();
                for (int i10 = 0; i10 < this.pipeListeners.size(); ++i10) {
                    this.pipeListeners.get(i10).onTransfer(this, buffer, length);
                }
            }
        }
        catch (IOException e10) {
            for (int i11 = 0; i11 < this.pipeListeners.size(); ++i11) {
                this.pipeListeners.get(i11).onError(this, e10);
            }
            this.stop();
        }
        return length;
    }

    @Override
    public boolean close() {
        this.stop();
        try {
            this.source.close();
            this.destination.close();
            return true;
        }
        catch (IOException e10) {
            logger.error(e10.getMessage(), e10);
            return false;
        }
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void addPipeListener(PipeListener pipeListener) {
        this.pipeListeners.add(pipeListener);
    }

    @Override
    public void removePipeListener(PipeListener pipeListener) {
        this.pipeListeners.remove(pipeListener);
    }

    public List<PipeListener> getPipeListeners() {
        return this.pipeListeners;
    }

    public void setPipeListeners(List<PipeListener> pipeListeners) {
        this.pipeListeners = pipeListeners;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Thread getRunningThread() {
        return this.runningThread;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }
}

