/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.server.Session;
import sockslib.server.listener.CloseSessionException;
import sockslib.server.listener.SessionListener;
import sockslib.server.msg.CommandMessage;

public class LoggingListener
implements SessionListener {
    private static final Logger logger = LoggerFactory.getLogger(LoggingListener.class);

    @Override
    public void onCreate(Session session) throws CloseSessionException {
        logger.info("Create SESSION[{}] for {}", (Object)session.getId(), (Object)session.getClientAddress());
    }

    @Override
    public void onCommand(Session session, CommandMessage message) throws CloseSessionException {
        logger.info("SESSION[{}] request:{}  {}:{}", new Object[]{session.getId(), message.getCommand(), message.getAddressType() != 3 ? message.getInetAddress() : message.getHost(), message.getPort()});
    }

    @Override
    public void onClose(Session session) {
        logger.info("SESSION[{}] closed", (Object)session.getId());
    }

    @Override
    public void onException(Session session, Exception exception) {
        logger.error("SESSION[{}] occurred error:{}, message:{}", session.getId(), exception.getClass().getSimpleName(), exception.getMessage());
        exception.printStackTrace();
    }
}

