/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server.manager;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.server.manager.User;
import sockslib.server.manager.UserManager;
import sockslib.utils.PathUtil;

public class FileBasedUserManager
implements UserManager {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedUserManager.class);
    private File storeFile;
    private StoreType storeType = StoreType.PROPERTIES;
    private Map<String, User> managedUsers;
    private boolean autoReload = false;
    private long reloadAfter = 20000L;
    private AutoReloadService autoReloadService;

    public FileBasedUserManager(File storeFile, StoreType storeType) throws IOException {
        this.storeFile = Preconditions.checkNotNull(storeFile, "Argument [storeFile] may not be null");
        this.storeType = Preconditions.checkNotNull(storeType, "Argument [storeType] may not be null");
        this.loadFromFile();
    }

    public FileBasedUserManager(File storeFile) throws IOException {
        this(storeFile, StoreType.PROPERTIES);
    }

    public FileBasedUserManager(String storeFile, boolean autoReload, long reloadAfter) throws IOException {
        storeFile = PathUtil.getAbstractPath(storeFile);
        this.storeFile = new File(storeFile);
        this.autoReload = autoReload;
        this.reloadAfter = reloadAfter;
        this.loadFromFile();
        if (this.autoReload) {
            this.autoReloadService = new AutoReloadService(this.reloadAfter);
            this.autoReloadService.start();
        }
    }

    public FileBasedUserManager(String storeFile) throws IOException {
        this(storeFile, false, 0L);
    }

    private void synchronizedWithFile() {
    }

    private void loadFromFile() throws IOException {
        if (this.managedUsers == null) {
            this.managedUsers = new HashMap<String, User>();
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(this.storeFile));
        Enumeration<?> enum1 = properties.propertyNames();
        while (enum1.hasMoreElements()) {
            String username = (String)enum1.nextElement();
            String password = properties.getProperty(username);
            User user = new User();
            user.setUsername(username);
            user.setPassword(password);
            this.managedUsers.put(username, user);
        }
    }

    @Override
    public void create(User user) {
        Preconditions.checkArgument(user != null && user.getUsername() != null, "User or username can't be null");
        this.managedUsers.put(user.getUsername(), user);
        logger.warn("Create a temporary user[{}]", (Object)user.getUsername());
    }

    @Override
    public UserManager addUser(String username, String password) {
        if (username == null) {
            throw new IllegalArgumentException("Username can't be null");
        }
        logger.warn("Create a temporary user[{}]", (Object)username);
        this.managedUsers.put(username, new User(username, password));
        return this;
    }

    @Override
    public User check(String username, String password) {
        User user = this.find(username);
        if (user != null && user.getPassword() != null && user.getPassword().equals(password)) {
            return user;
        }
        return null;
    }

    @Override
    public void delete(String username) {
        this.managedUsers.remove(username);
    }

    @Override
    public List<User> findAll() {
        return null;
    }

    @Override
    public void update(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User can't null");
        }
        if (Strings.isNullOrEmpty(user.getUsername())) {
            throw new IllegalArgumentException("Username of the user can't be null or empty");
        }
        this.managedUsers.put(user.getUsername(), user);
        logger.warn("Update user[{}] temporarily", (Object)user.getUsername());
    }

    @Override
    public User find(String username) {
        if (Strings.isNullOrEmpty(username)) {
            throw new IllegalArgumentException("Username can't be null or empty");
        }
        return this.managedUsers.get(username);
    }

    public File getStoreFile() {
        return this.storeFile;
    }

    public void setStoreFile(File storeFile) {
        this.storeFile = storeFile;
    }

    public StoreType getStoreType() {
        return this.storeType;
    }

    public void setStoreType(StoreType storeType) {
        this.storeType = storeType;
    }

    public Map<String, User> getManagedUsers() {
        return this.managedUsers;
    }

    public void setManagedUsers(Map<String, User> managedUsers) {
        this.managedUsers = managedUsers;
    }

    public boolean isAutoReload() {
        return this.autoReload;
    }

    public void setAutoReload(boolean autoReload) {
        this.autoReload = autoReload;
    }

    public long getReloadAfter() {
        return this.reloadAfter;
    }

    public void setReloadAfter(long reloadAfter) {
        this.reloadAfter = reloadAfter;
    }

    public AutoReloadService getAutoReloadService() {
        return this.autoReloadService;
    }

    public void setAutoReloadService(AutoReloadService autoReloadService) {
        this.autoReloadService = autoReloadService;
    }

    private class AutoReloadService
    implements Runnable {
        private Thread thread;
        private long reloadAfter;
        private boolean stop;

        public AutoReloadService(long reloadAfter) {
            this.reloadAfter = reloadAfter;
        }

        public void start() {
            this.stop = false;
            this.thread = new Thread((Runnable)this, "AutoReloadService");
            this.thread.setDaemon(true);
            this.thread.start();
        }

        public void stop() {
            this.stop = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }

        @Override
        public void run() {
            while (!this.stop) {
                try {
                    Thread.sleep(this.reloadAfter);
                }
                catch (InterruptedException e10) {
                    logger.error(e10.getMessage(), e10);
                }
                try {
                    FileBasedUserManager.this.loadFromFile();
                }
                catch (IOException e11) {
                    logger.error(e11.getMessage(), e11);
                }
            }
        }
    }

    public static enum StoreType {
        PROPERTIES;

    }
}

