/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server.manager;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mongodb.client.FindIterable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.server.manager.MongoDBConfiguration;
import sockslib.server.manager.NonePasswordProtector;
import sockslib.server.manager.PasswordProtector;
import sockslib.server.manager.User;
import sockslib.server.manager.UserManager;
import sockslib.utils.mongo.MongoDBUtil;

public class MongoDBBasedUserManager
implements UserManager {
    private static final Logger logger = LoggerFactory.getLogger(MongoDBBasedUserManager.class);
    private static final String COLLECTION_NAME = "users";
    private static final String USER_USERNAME_KEY = "un";
    private static final String USER_PASSWORD_KEY = "pw";
    private String usernameKey = "un";
    private String passwordKey = "pw";
    private String userCollectionName = "users";
    private LoadingCache<String, User> cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(5L, TimeUnit.MINUTES).build(new CacheLoader<String, User>(){

        @Override
        public User load(String key) throws Exception {
            User user = MongoDBBasedUserManager.this.fetchUserFromMongoDB(key);
            if (user == null) {
                return new User();
            }
            return user;
        }
    });
    private MongoDBUtil mongoDBUtil;
    private PasswordProtector passwordProtector;

    public MongoDBBasedUserManager(String host, int port, String databaseName) {
        this(host, port, databaseName, null, null);
    }

    public MongoDBBasedUserManager(MongoDBConfiguration configuration) {
        this(configuration.getHost(), configuration.getPort(), configuration.getDatabase(), configuration.getUsername(), configuration.getPassword());
    }

    public MongoDBBasedUserManager(String host, int port, String databaseName, String username, String password) {
        this(new MongoDBUtil(host, port, databaseName, username, password));
    }

    public MongoDBBasedUserManager(MongoDBUtil mongoDBUtil) {
        this.mongoDBUtil = mongoDBUtil;
        this.passwordProtector = new NonePasswordProtector();
    }

    public User fetchUserFromMongoDB(String username) {
        return this.mongoDBUtil.execute(this.userCollectionName, collection -> {
            Document document = (Document)collection.find((Bson)new Document(this.usernameKey, (Object)username)).first();
            if (document != null) {
                return this.formUser(document);
            }
            return null;
        });
    }

    @Override
    public void create(User user) {
        user.setPassword(this.generateEncryptPassword(user));
        this.mongoDBUtil.execute(this.userCollectionName, collection -> {
            collection.insertOne((Object)new Document().append(this.usernameKey, (Object)user.getUsername()).append(this.passwordKey, (Object)user.getPassword()));
            return null;
        });
    }

    @Override
    public UserManager addUser(String username, String password) {
        User user = new User(username, password);
        user.setPassword(this.generateEncryptPassword(user));
        this.mongoDBUtil.execute(this.userCollectionName, collection -> {
            collection.insertOne((Object)new Document().append(this.usernameKey, (Object)user.getUsername()).append(this.passwordKey, (Object)user.getPassword()));
            return null;
        });
        return this;
    }

    @Override
    public User check(String username, String password) {
        if (username == null || password == null) {
            return null;
        }
        User user = this.cache.getUnchecked(username);
        if (user == null || user.getUsername() == null || user.getPassword() == null) {
            return null;
        }
        String encryptPassword = this.generateEncryptPassword(user, password);
        if (user.getPassword().equals(encryptPassword)) {
            return user;
        }
        return null;
    }

    @Override
    public void delete(String username) {
        this.mongoDBUtil.execute(this.userCollectionName, collection -> {
            collection.deleteOne((Bson)new Document(this.usernameKey, (Object)username));
            return null;
        });
        this.cache.put(username, new User());
    }

    @Override
    public List<User> findAll() {
        return this.mongoDBUtil.execute(this.userCollectionName, collection -> {
            FindIterable result = collection.find();
            ArrayList<User> users = new ArrayList<User>();
            for (Document document : result) {
                users.add(this.formUser(document));
            }
            return users;
        });
    }

    @Override
    public void update(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User can't null");
        }
        if (Strings.isNullOrEmpty(user.getUsername())) {
            throw new IllegalArgumentException("Username of the user can't be null or empty");
        }
        User old = this.find(user.getUsername());
        String newEncryptPassword = this.generateEncryptPassword(user);
        if (!old.getPassword().equals(newEncryptPassword)) {
            user.setPassword(newEncryptPassword);
        }
        this.mongoDBUtil.execute(this.userCollectionName, collection -> {
            collection.updateOne((Bson)new Document(this.usernameKey, (Object)user.getUsername()), (Bson)new Document("$set", (Object)new Document(this.usernameKey, (Object)user.getPassword())));
            return null;
        });
        this.cache.put(user.getUsername(), user);
    }

    @Override
    public User find(String username) {
        User user = this.cache.getUnchecked(username);
        if (user.getUsername() == null) {
            return null;
        }
        return user;
    }

    private User formUser(Document document) {
        User user = new User();
        user.setUsername(document.getString((Object)this.usernameKey));
        user.setPassword(document.getString((Object)this.passwordKey));
        return user;
    }

    public LoadingCache<String, User> getCache() {
        return this.cache;
    }

    public void setCache(LoadingCache<String, User> cache) {
        this.cache = cache;
    }

    public MongoDBUtil getMongoDBUtil() {
        return this.mongoDBUtil;
    }

    public void setMongoDBUtil(MongoDBUtil mongoDBUtil) {
        this.mongoDBUtil = mongoDBUtil;
    }

    public PasswordProtector getPasswordProtector() {
        return this.passwordProtector;
    }

    public void setPasswordProtector(PasswordProtector passwordProtector) {
        this.passwordProtector = passwordProtector;
    }

    private String generateEncryptPassword(User user, String newPassword) {
        User tempUser = user.copy();
        if (newPassword != null) {
            tempUser.setPassword(newPassword);
        }
        if (this.passwordProtector == null) {
            this.passwordProtector = new NonePasswordProtector();
        }
        return this.passwordProtector.encrypt(tempUser);
    }

    private String generateEncryptPassword(User user) {
        return this.generateEncryptPassword(user, null);
    }

    public String getUserCollectionName() {
        return this.userCollectionName;
    }

    public void setUserCollectionName(String userCollectionName) {
        this.userCollectionName = userCollectionName;
    }

    public String getUsernameKey() {
        return this.usernameKey;
    }

    public void setUsernameKey(String usernameKey) {
        this.usernameKey = usernameKey;
    }

    public String getPasswordKey() {
        return this.passwordKey;
    }

    public void setPasswordKey(String passwordKey) {
        this.passwordKey = passwordKey;
    }
}

