/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server.msg;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import sockslib.common.AddressType;
import sockslib.common.SocksCommand;
import sockslib.common.SocksException;
import sockslib.server.msg.ReadableMessage;
import sockslib.server.msg.ServerReply;
import sockslib.server.msg.WritableMessage;
import sockslib.utils.SocksUtil;
import sockslib.utils.StreamUtil;

public class CommandMessage
implements ReadableMessage,
WritableMessage {
    protected static final int CMD_CONNECT = 1;
    protected static final int CMD_BIND = 2;
    protected static final int CMD_UDP_ASSOCIATE = 3;
    private static final int RESERVED = 0;
    private int version;
    private InetAddress inetAddress;
    private int port;
    private String host;
    private SocksCommand command;
    private int reserved;
    private int addressType;
    private SocksException socksException;

    @Override
    public int getLength() {
        byte[] bytes = this.getBytes();
        return bytes != null ? bytes.length : 0;
    }

    @Override
    public byte[] getBytes() {
        byte[] bytes = null;
        switch (this.addressType) {
            case 1: {
                bytes = new byte[10];
                byte[] ipv4Bytes = this.inetAddress.getAddress();
                System.arraycopy(ipv4Bytes, 0, bytes, 4, ipv4Bytes.length);
                bytes[8] = SocksUtil.getFirstByteFromInt(this.port);
                bytes[9] = SocksUtil.getSecondByteFromInt(this.port);
                break;
            }
            case 4: {
                bytes = new byte[22];
                byte[] ipv6Bytes = this.inetAddress.getAddress();
                System.arraycopy(ipv6Bytes, 0, bytes, 4, ipv6Bytes.length);
                bytes[20] = SocksUtil.getFirstByteFromInt(this.port);
                bytes[21] = SocksUtil.getSecondByteFromInt(this.port);
                break;
            }
            case 3: {
                int hostLength = this.host.getBytes().length;
                bytes = new byte[7 + hostLength];
                bytes[4] = (byte)hostLength;
                for (int i10 = 0; i10 < hostLength; ++i10) {
                    bytes[5 + i10] = this.host.getBytes()[i10];
                }
                bytes[5 + hostLength] = SocksUtil.getFirstByteFromInt(this.port);
                bytes[6 + hostLength] = SocksUtil.getSecondByteFromInt(this.port);
                break;
            }
        }
        if (bytes != null) {
            bytes[0] = (byte)this.version;
            bytes[1] = (byte)this.command.getValue();
            bytes[2] = 0;
            bytes[3] = (byte)this.addressType;
        }
        return bytes;
    }

    @Override
    public void read(InputStream inputStream) throws SocksException, IOException {
        this.version = StreamUtil.checkEnd(inputStream.read());
        int cmd = StreamUtil.checkEnd(inputStream.read());
        switch (cmd) {
            case 1: {
                this.command = SocksCommand.CONNECT;
                break;
            }
            case 2: {
                this.command = SocksCommand.BIND;
                break;
            }
            case 3: {
                this.command = SocksCommand.UDP_ASSOCIATE;
                break;
            }
            default: {
                this.socksException = SocksException.serverReplyException(ServerReply.COMMAND_NOT_SUPPORTED);
            }
        }
        this.reserved = StreamUtil.checkEnd(inputStream.read());
        this.addressType = StreamUtil.checkEnd(inputStream.read());
        if (!AddressType.isSupport(this.addressType) && this.socksException == null) {
            this.socksException = SocksException.serverReplyException(ServerReply.ADDRESS_TYPE_NOT_SUPPORTED);
        }
        switch (this.addressType) {
            case 1: {
                byte[] addressBytes = StreamUtil.read(inputStream, 4);
                this.inetAddress = InetAddress.getByAddress(addressBytes);
                break;
            }
            case 4: {
                byte[] addressBytes6 = StreamUtil.read(inputStream, 16);
                this.inetAddress = InetAddress.getByAddress(addressBytes6);
                break;
            }
            case 3: {
                int domainLength = StreamUtil.checkEnd(inputStream.read());
                if (domainLength < 1) {
                    throw new SocksException("Length of domain must great than 0");
                }
                byte[] domainBytes = StreamUtil.read(inputStream, domainLength);
                this.host = new String(domainBytes, Charset.forName("UTF-8"));
                try {
                    this.inetAddress = InetAddress.getByName(this.host);
                }
                catch (UnknownHostException e10) {
                    if (this.socksException != null) break;
                    this.socksException = SocksException.serverReplyException(ServerReply.HOST_UNREACHABLE);
                }
                break;
            }
        }
        byte[] portBytes = StreamUtil.read(inputStream, 2);
        this.port = SocksUtil.bytesToInt(portBytes);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean hasSocksException() {
        return this.socksException != null;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public SocksCommand getCommand() {
        return this.command;
    }

    public void setCommand(SocksCommand command) {
        this.command = command;
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int reserved) {
        this.reserved = reserved;
    }

    public int getAddressType() {
        return this.addressType;
    }

    public void setAddressType(int addressType) {
        this.addressType = addressType;
    }

    public SocketAddress getSocketAddress() {
        return new InetSocketAddress(this.inetAddress, this.port);
    }

    public SocksException getSocksException() {
        return this.socksException;
    }

    public void setSocksException(SocksException socksException) {
        this.socksException = socksException;
    }
}

