/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server.msg;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.common.NotImplementException;
import sockslib.server.msg.ServerReply;
import sockslib.server.msg.WritableMessage;
import sockslib.utils.SocksUtil;

public class CommandResponseMessage
implements WritableMessage {
    protected static final Logger logger = LoggerFactory.getLogger(CommandResponseMessage.class);
    private int version = 5;
    private int reserved = 0;
    private int addressType = 1;
    private InetAddress bindAddress;
    private int bindPort;
    private ServerReply reply;

    public CommandResponseMessage(ServerReply reply) {
        byte[] defaultAddress = new byte[]{0, 0, 0, 0};
        this.reply = reply;
        try {
            this.bindAddress = InetAddress.getByAddress(defaultAddress);
            this.addressType = 1;
        }
        catch (UnknownHostException e10) {
            logger.error(e10.getMessage(), e10);
        }
    }

    public CommandResponseMessage(int version, ServerReply reply, InetAddress bindAddress, int bindPort) {
        this.version = version;
        this.reply = reply;
        this.bindAddress = bindAddress;
        this.bindPort = bindPort;
        this.addressType = bindAddress.getAddress().length == 4 ? 1 : 4;
    }

    @Override
    public byte[] getBytes() {
        byte[] bytes = null;
        switch (this.addressType) {
            case 1: {
                bytes = new byte[10];
                for (int i10 = 0; i10 < this.bindAddress.getAddress().length; ++i10) {
                    bytes[i10 + 4] = this.bindAddress.getAddress()[i10];
                }
                bytes[8] = SocksUtil.getFirstByteFromInt(this.bindPort);
                bytes[9] = SocksUtil.getSecondByteFromInt(this.bindPort);
                break;
            }
            case 4: {
                bytes = new byte[22];
                for (int i11 = 0; i11 < this.bindAddress.getAddress().length; ++i11) {
                    bytes[i11 + 4] = this.bindAddress.getAddress()[i11];
                }
                bytes[20] = SocksUtil.getFirstByteFromInt(this.bindPort);
                bytes[21] = SocksUtil.getSecondByteFromInt(this.bindPort);
                break;
            }
            case 3: {
                throw new NotImplementException();
            }
        }
        bytes[0] = (byte)this.version;
        bytes[1] = this.reply.getValue();
        bytes[2] = (byte)this.reserved;
        bytes[3] = (byte)this.addressType;
        return bytes;
    }

    @Override
    public int getLength() {
        return this.getBytes().length;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getAddressType() {
        return this.addressType;
    }

    public void setAddressType(int addressType) {
        this.addressType = addressType;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public void setBindPort(int bindPort) {
        this.bindPort = bindPort;
    }

    public ServerReply getReply() {
        return this.reply;
    }

    public void setReply(ServerReply reply) {
        this.reply = reply;
    }
}

