/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server.msg;

import java.io.IOException;
import java.io.InputStream;
import sockslib.common.SocksException;
import sockslib.server.msg.ReadableMessage;
import sockslib.server.msg.WritableMessage;
import sockslib.utils.StreamUtil;

public class MethodSelectionMessage
implements ReadableMessage,
WritableMessage {
    private int version;
    private int methodNum;
    private int[] methods;

    @Override
    public byte[] getBytes() {
        byte[] bytes = new byte[2 + this.methodNum];
        bytes[0] = (byte)this.version;
        bytes[1] = (byte)this.methodNum;
        for (int i10 = 0; i10 < this.methods.length; ++i10) {
            bytes[i10 + 2] = (byte)this.methods[i10];
        }
        return bytes;
    }

    @Override
    public int getLength() {
        return this.getBytes().length;
    }

    @Override
    public void read(InputStream inputStream) throws SocksException, IOException {
        this.version = StreamUtil.checkEnd(inputStream.read());
        this.methodNum = StreamUtil.checkEnd(inputStream.read());
        this.methods = new int[this.methodNum];
        for (int i10 = 0; i10 < this.methodNum; ++i10) {
            this.methods[i10] = StreamUtil.checkEnd(inputStream.read());
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getMethodNum() {
        return this.methodNum;
    }

    public void setMethodNum(int methodNum) {
        this.methodNum = methodNum;
    }

    public int[] getMethods() {
        return this.methods;
    }

    public void setMethods(int[] methods) {
        this.methods = methods;
    }
}

