/*
 * Decompiled with CFR 0.152.
 */
package sockslib.utils;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class Arguments {
    private final String[] args;
    private final Map<String, Integer> argPositionMap;

    public Arguments(@Nullable String[] args) {
        this.args = args;
        this.argPositionMap = new HashMap<String, Integer>();
        if (args != null) {
            for (int i10 = 0; i10 < args.length; ++i10) {
                this.argPositionMap.put(args[i10], i10);
            }
        }
    }

    public static <T> T valueOf(String arg, Class<T> type) {
        Preconditions.checkNotNull(arg, "Argument [arg] may not be null");
        Preconditions.checkNotNull(type, "Argument [type] may not be null");
        Object value = arg.trim();
        if (arg.contains("=")) {
            value = arg.split("=")[1].trim();
        }
        if (!type.equals(String.class)) {
            if (type.equals(Integer.class)) {
                value = Integer.parseInt((String)value);
            } else if (type.equals(Long.class)) {
                value = Long.parseLong((String)value);
            } else {
                throw new IllegalArgumentException("Not support" + type.getName());
            }
        }
        return (T)value;
    }

    public static String valueOf(String arg) {
        return Arguments.valueOf(arg, String.class);
    }

    public static int intValueOf(String arg) {
        return Arguments.valueOf(arg, Integer.class);
    }

    public static long longValueOf(String arg) {
        return Arguments.valueOf(arg, Long.class);
    }

    public static boolean isHelpArg(String arg) {
        return (arg = arg.trim()).equals("-h") || arg.equals("--help");
    }

    public String argAt(int index) {
        return this.argAt(index, null);
    }

    public String argAt(int index, @Nullable String defaultValue) {
        if (this.args == null || index >= this.args.length || index < 0) {
            return defaultValue;
        }
        return this.args[index];
    }

    public boolean hasArg(String arg) {
        return this.argPositionMap.get(arg) != null;
    }

    public boolean hasOneOfArgs(String ... args) {
        for (String arg : args) {
            if (this.argPositionMap.get(arg) == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasArgsIn(String ... args) {
        for (String arg : args) {
            if (this.argPositionMap.get(arg) == null) continue;
            return true;
        }
        return false;
    }

    public String getValue(String arg, @Nullable String defaultValue) {
        Integer index = this.argPositionMap.get(Preconditions.checkNotNull(arg));
        if (index == null) {
            return defaultValue;
        }
        if (index + 1 < this.args.length) {
            return this.args[index + 1];
        }
        return defaultValue;
    }

    public long getLongValue(String arg, long defaultValue) {
        String value = this.getValue(arg, null);
        if (value == null) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public int getIntValue(String arg, int defaultValue) {
        String value = this.getValue(arg, null);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public boolean getBooleanValue(String arg, boolean defaultValue) {
        String value = this.getValue(arg, null);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public String getValue(List<String> args, @Nullable String defaultValue) {
        Preconditions.checkNotNull(args);
        String value = defaultValue;
        for (String arg : args) {
            value = this.getValue(arg, value);
        }
        return value;
    }

    public int getIntValue(List<String> args, int defaultValue) {
        int value = defaultValue;
        for (String arg : args) {
            value = this.getIntValue(arg, value);
        }
        return value;
    }

    public long getLongValue(List<String> args, long defaultValue) {
        long value = defaultValue;
        for (String arg : args) {
            value = this.getLongValue(arg, value);
        }
        return value;
    }

    public boolean getBooleanValue(List<String> args, boolean defaultValue) {
        boolean value = defaultValue;
        for (String arg : args) {
            value = this.getBooleanValue(arg, value);
        }
        return value;
    }

    public String getValueFromArg(String prefix, String splitRegex, @Nullable String defaultValue) {
        Preconditions.checkNotNull(prefix);
        Preconditions.checkNotNull(splitRegex);
        for (String arg : this.args) {
            if (!arg.startsWith(prefix)) continue;
            String[] nameValue = arg.split(splitRegex);
            if (nameValue.length >= 2) {
                return nameValue[1];
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public int getIntValueFromArg(String prefix, String splitRegex, int defaultValue) {
        String value = this.getValueFromArg(prefix, splitRegex, null);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public long getLongValueFromArg(String prefix, String splitRegex, long defaultValue) {
        String value = this.getValueFromArg(prefix, splitRegex, null);
        if (value == null) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public boolean getBooleanValueFromArg(String prefix, String splitRegex, boolean defaultValue) {
        String value = this.getValueFromArg(prefix, splitRegex, null);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public String[] getArgs() {
        return this.args;
    }
}

