/*
 * Decompiled with CFR 0.152.
 */
package sockslib.utils;

import com.google.common.base.Preconditions;
import sockslib.utils.UnsignedByte;

public class LogMessageBuilder {
    public static String build(byte[] bytes, MsgType type) {
        return LogMessageBuilder.build(bytes, bytes.length, type);
    }

    public static String build(byte[] bytes, int size, MsgType type) {
        Preconditions.checkNotNull(bytes, "Argument [bytes] may not be null");
        Preconditions.checkNotNull(type, "Argument [type] may not be null");
        StringBuilder debugMsg = new StringBuilder();
        switch (type) {
            case RECEIVE: {
                debugMsg.append("Received: ");
                break;
            }
            case SEND: {
                debugMsg.append("Sent: ");
                break;
            }
        }
        for (int i10 = 0; i10 < size; ++i10) {
            int x10 = UnsignedByte.toInt(bytes[i10]);
            debugMsg.append(Integer.toHexString(x10)).append(" ");
        }
        return debugMsg.toString();
    }

    public static String bytesToHexString(byte[] bytes) {
        Preconditions.checkNotNull(bytes, "Argument [bytes] may not be null");
        StringBuilder buffer = new StringBuilder();
        for (int i10 = 0; i10 < bytes.length; ++i10) {
            buffer.append(UnsignedByte.toHexString(bytes[i10]));
            if (i10 >= bytes.length - 1) continue;
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public static enum MsgType {
        SEND,
        RECEIVE;

    }
}

