/*
 * Decompiled with CFR 0.152.
 */
package sockslib.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtil {
    private static final Logger logger = LoggerFactory.getLogger(ResourceUtil.class);

    public static void close(InputStream inputStream, OutputStream outputStream, Socket socket) {
        ResourceUtil.close(inputStream, outputStream, socket, null);
    }

    public static void close(InputStream inputStream, OutputStream outputStream, Socket socket, ServerSocket serverSocket) {
        ResourceUtil.close(inputStream);
        ResourceUtil.close(outputStream);
        ResourceUtil.close(socket);
        ResourceUtil.close(serverSocket);
    }

    public static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e10) {
                logger.error(e10.getMessage(), e10);
            }
        }
    }

    public static void close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e10) {
                logger.error(e10.getMessage(), e10);
            }
        }
    }

    public static void close(Socket socket) {
        if (socket != null && !socket.isClosed()) {
            try {
                socket.close();
            }
            catch (IOException e10) {
                logger.error(e10.getMessage(), e10);
            }
        }
    }

    public static void close(ServerSocket serverSocket) {
        if (serverSocket != null && !serverSocket.isClosed()) {
            try {
                serverSocket.close();
            }
            catch (IOException e10) {
                logger.error(e10.getMessage(), e10);
            }
        }
    }

    public static void close(DatagramSocket datagramSocket) {
        if (datagramSocket != null) {
            datagramSocket.close();
        }
    }
}

