/*
 * Decompiled with CFR 0.152.
 */
package sockslib.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.utils.TimerThread;

public class Timer {
    private static final Logger logger = LoggerFactory.getLogger(Timer.class);
    private long startTime;
    private long endTime;

    private Timer(long startTime) {
        this.startTime = startTime;
    }

    public static Timer start() {
        return new Timer(System.currentTimeMillis());
    }

    public static void open() {
        Runtime.getRuntime().addShutdownHook(new TimerThread(Timer.start()));
    }

    public long stop() {
        this.endTime = System.currentTimeMillis();
        return this.endTime - this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTotalTime() {
        return this.endTime - this.startTime;
    }
}

