/*
 * Decompiled with CFR 0.152.
 */
package sockslib.utils.jdbc;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.utils.jdbc.ReadOnlyResultSet;
import sockslib.utils.jdbc.RowMapper;
import sockslib.utils.jdbc.TypeUtil;

public class JdbcTemplate {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTemplate.class);
    private DataSource dataSource;

    public JdbcTemplate(DataSource dataSource) {
        this.dataSource = Preconditions.checkNotNull(dataSource, "Argument [dataSource] may not null");
    }

    public int deleteAll(String tableName) {
        String sql = "delete from " + tableName;
        return this.execute(sql);
    }

    public int execute(String sql) {
        return this.execute(sql, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String sql, Object[] args) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement(sql);
            this.setParameter(preparedStatement, args);
            int result = preparedStatement.executeUpdate();
            connection.commit();
            connection.rollback();
            int n10 = result;
            this.close(preparedStatement);
            this.close(connection);
            return n10;
        }
        catch (SQLException e10) {
            try {
                logger.error(e10.getMessage(), e10);
                this.close(preparedStatement);
                this.close(connection);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement);
                this.close(connection);
                throw throwable;
            }
        }
        return 0;
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper) {
        return this.query(sql, null, rowMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> query(String sql, Object[] args, RowMapper<T> rowMapper) {
        ArrayList<T> entities = new ArrayList<T>();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement(sql);
            this.setParameter(preparedStatement, args);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                entities.add(rowMapper.map(new ReadOnlyResultSet(resultSet)));
            }
            connection.commit();
            this.close(resultSet);
            this.close(preparedStatement);
            this.close(connection);
        }
        catch (SQLException e10) {
            try {
                logger.error(e10.getMessage(), e10);
                this.close(resultSet);
                this.close(preparedStatement);
                this.close(connection);
            }
            catch (Throwable throwable) {
                this.close(resultSet);
                this.close(preparedStatement);
                this.close(connection);
                throw throwable;
            }
        }
        return entities;
    }

    private void setParameter(PreparedStatement preparedStatement, Object[] args) throws SQLException {
        if (args == null || args.length == 0) {
            return;
        }
        for (int i10 = 0; i10 < args.length; ++i10) {
            Object arg = args[i10];
            if (TypeUtil.isInt(arg)) {
                preparedStatement.setInt(i10 + 1, (Integer)arg);
                continue;
            }
            if (TypeUtil.isString(arg)) {
                preparedStatement.setString(i10 + 1, (String)arg);
                continue;
            }
            if (TypeUtil.isLong(arg)) {
                preparedStatement.setLong(i10 + 1, (Long)arg);
                continue;
            }
            if (TypeUtil.isDouble(arg)) {
                preparedStatement.setDouble(i10 + 1, (Double)arg);
                continue;
            }
            if (TypeUtil.isFloat(arg)) {
                preparedStatement.setFloat(i10 + 1, ((Float)arg).floatValue());
                continue;
            }
            if (TypeUtil.isBoolean(arg)) {
                preparedStatement.setBoolean(i10 + 1, (Boolean)arg);
                continue;
            }
            if (TypeUtil.isByte(arg)) {
                preparedStatement.setByte(i10 + 1, (Byte)arg);
                continue;
            }
            if (TypeUtil.isDate(arg)) {
                preparedStatement.setDate(i10 + 1, (Date)arg);
                continue;
            }
            if (TypeUtil.isShort(arg)) {
                preparedStatement.setShort(i10 + 1, (Short)arg);
                continue;
            }
            if (TypeUtil.isArray(arg)) {
                preparedStatement.setArray(i10 + 1, (Array)arg);
                continue;
            }
            if (TypeUtil.isInputStream(arg)) {
                preparedStatement.setAsciiStream(i10 + 1, (InputStream)arg);
                continue;
            }
            if (TypeUtil.isBigDecimal(arg)) {
                preparedStatement.setBigDecimal(i10 + 1, (BigDecimal)arg);
                continue;
            }
            if (TypeUtil.isBlob(arg)) {
                preparedStatement.setBlob(i10 + 1, (Blob)arg);
                continue;
            }
            if (TypeUtil.isBytes(arg)) {
                preparedStatement.setBytes(i10 + 1, (byte[])arg);
                continue;
            }
            if (TypeUtil.isClob(arg)) {
                preparedStatement.setClob(i10 + 1, (Clob)arg);
                continue;
            }
            if (TypeUtil.isNClob(arg)) {
                preparedStatement.setNClob(i10 + 1, (NClob)arg);
                continue;
            }
            throw new IllegalArgumentException("Type:" + arg.getClass().getName() + " is not supported");
        }
    }

    private void close(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException e10) {
            logger.error(e10.getMessage(), e10);
        }
    }

    private void close(PreparedStatement preparedStatement) {
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (SQLException e10) {
            logger.error(e10.getMessage(), e10);
        }
    }

    private void close(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e10) {
            logger.error(e10.getMessage(), e10);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

