/*
 * Decompiled with CFR 0.152.
 */
package sockslib.utils.mongo;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import org.bson.Document;
import org.bson.conversions.Bson;
import sockslib.utils.mongo.CollectionCallback;

public class MongoDBUtil {
    private String host;
    private int port = 27017;
    private String username;
    private String password;
    private String databaseName;
    private MongoClient mongoClient;

    public MongoDBUtil() {
    }

    public MongoDBUtil(String host, int port, String databaseName) {
        this.host = host;
        this.port = port;
        this.databaseName = databaseName;
    }

    public MongoDBUtil(String host, int port, String databaseName, String username, String password) {
        this.host = host;
        this.port = port;
        this.databaseName = databaseName;
        this.username = username;
        this.password = password;
    }

    public DeleteResult deleteAll(String collectionName) {
        return this.execute(collectionName, collection -> collection.deleteMany((Bson)new Document()));
    }

    public void dropCollection(String collectionName) {
        this.execute(collectionName, collection -> {
            collection.drop();
            return null;
        });
    }

    public <T> T execute(String collectionName, CollectionCallback<T> callback) {
        Object database = null;
        if (this.mongoClient == null) {
            this.mongoClient = this.getConnectedClient();
        }
        return callback.doInCollection((MongoCollection<Document>)this.mongoClient.getDatabase(this.databaseName).getCollection(collectionName));
    }

    public void closeConnection() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T connect(String collectionName, CollectionCallback<T> callback) {
        T t10 = null;
        try (MongoClient client = null;){
            client = this.getConnectedClient();
            MongoDatabase database = client.getDatabase(this.databaseName);
            MongoCollection collection = database.getCollection(collectionName);
            t10 = callback.doInCollection((MongoCollection<Document>)collection);
        }
        return t10;
    }

    public MongoCollection getCollection(String collectionName) {
        if (this.mongoClient == null) {
            this.mongoClient = this.getConnectedClient();
        }
        return this.mongoClient.getDatabase(this.databaseName).getCollection(collectionName);
    }

    private MongoClient getConnectedClient() {
        if (Strings.isNullOrEmpty(this.username)) {
            return new MongoClient(this.host, this.port);
        }
        MongoCredential credential = MongoCredential.createCredential((String)this.username, (String)this.databaseName, (char[])this.password.toCharArray());
        return new MongoClient(new ServerAddress(this.host, this.port), Lists.newArrayList(credential));
    }
}

