/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.DownloadEvent;
import com.sun.applet2.preloader.event.PreloaderEvent;
import com.sun.deploy.util.URLUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import sun.net.ProgressEvent;
import sun.net.ProgressListener;
import sun.plugin.util.ProgressMonitor;

public class ProgressMonitorAdapter
implements ProgressListener {
    private int numJarTotal = 0;
    private int numberOfJarLoaded = 0;
    private final ArrayList<Object> progressSourceFilterList = new ArrayList();
    private URL[] jarURLs = new URL[0];
    private final HashMap<URL, ProgressEvent> downloadInProgressMap = new HashMap();
    private URL codebaseURL;
    Preloader delegate;

    public ProgressMonitorAdapter(Preloader preloader) {
        this.delegate = preloader;
    }

    public void setProgressFilter(URL uRL, String string) {
        this.codebaseURL = uRL;
        if (string != null) {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            URL[] uRLArray = new URL[]{};
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                try {
                    object = new URL(uRL, string2);
                    if (!URLUtil.checkTargetURL((URL)uRL, (URL)object)) {
                        throw new SecurityException("Permission denied: " + object);
                    }
                    arrayList.add(object);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
            uRLArray = new URL[arrayList.size()];
            int n = 0;
            object = arrayList.iterator();
            while (object.hasNext()) {
                uRLArray[n] = (URL)object.next();
                ++n;
            }
            this.jarURLs = uRLArray;
            this.numJarTotal = uRLArray.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressStart(ProgressEvent progressEvent) {
        ArrayList<Object> arrayList = this.progressSourceFilterList;
        synchronized (arrayList) {
            if (this.progressSourceFilterList.contains(progressEvent.getSource())) {
                return;
            }
            if (this.numJarTotal > 0) {
                for (URL uRL : this.jarURLs) {
                    if (!progressEvent.getURL().equals(uRL)) continue;
                    this.progressSourceFilterList.add(progressEvent.getSource());
                    HashMap<URL, ProgressEvent> hashMap = this.downloadInProgressMap;
                    synchronized (hashMap) {
                        this.downloadInProgressMap.put(progressEvent.getURL(), progressEvent);
                        break;
                    }
                }
            } else if (progressEvent.getURL().toString().startsWith(this.codebaseURL.toString())) {
                this.progressSourceFilterList.add(progressEvent.getSource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressUpdate(ProgressEvent progressEvent) {
        Cloneable cloneable = this.progressSourceFilterList;
        synchronized (cloneable) {
            if (this.progressSourceFilterList.isEmpty()) {
                this.progressStart(progressEvent);
            }
            if (!this.progressSourceFilterList.contains(progressEvent.getSource())) {
                return;
            }
        }
        if (this.numJarTotal > 0) {
            cloneable = this.downloadInProgressMap;
            synchronized (cloneable) {
                this.downloadInProgressMap.put(progressEvent.getURL(), progressEvent);
            }
            this.sendEvent(progressEvent.getURL(), ProgressMonitor.getProgress(progressEvent), ProgressMonitor.getExpected(progressEvent), this.getCurrentProgress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressFinish(ProgressEvent progressEvent) {
        int n = 0;
        boolean bl = false;
        Cloneable cloneable = this.progressSourceFilterList;
        synchronized (cloneable) {
            if (!this.progressSourceFilterList.contains(progressEvent.getSource())) {
                return;
            }
            this.progressSourceFilterList.remove(progressEvent.getSource());
        }
        if (ProgressMonitor.getProgress(progressEvent) == 0L) {
            this.downloadInProgressMap.remove(progressEvent.getURL());
            return;
        }
        if (this.numJarTotal > 0) {
            cloneable = this.downloadInProgressMap;
            synchronized (cloneable) {
                this.downloadInProgressMap.remove(progressEvent.getURL());
                ++this.numberOfJarLoaded;
                n = this.numJarTotal == this.numberOfJarLoaded ? 100 : this.getCurrentProgress();
            }
        } else {
            int n2 = (100 - n) / 2;
            n += n2;
        }
        if (!bl) {
            this.sendEvent(progressEvent.getURL(), ProgressMonitor.getProgress(progressEvent), ProgressMonitor.getExpected(progressEvent), n);
        }
    }

    private void sendEvent(URL uRL, long l, long l2, long l3) {
        try {
            this.delegate.handleEvent((PreloaderEvent)new DownloadEvent(0, uRL, null, null, (long)((int)l), (long)((int)l2), (int)l3));
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCurrentProgress() {
        if (this.numJarTotal == 0) {
            return 100;
        }
        double d = 100.0 / (double)this.numJarTotal;
        double d2 = d * (double)this.numberOfJarLoaded;
        HashMap<URL, ProgressEvent> hashMap = this.downloadInProgressMap;
        synchronized (hashMap) {
            for (ProgressEvent progressEvent : this.downloadInProgressMap.values()) {
                long l = ProgressMonitor.getExpected(progressEvent);
                if (l > 0L) {
                    d2 += d * (double)ProgressMonitor.getProgress(progressEvent) / (double)l;
                    continue;
                }
                d2 += d / 2.0;
            }
        }
        if (d2 < 100.0) {
            return (int)d2;
        }
        return 100;
    }
}

