/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association.utility;

import com.sun.deploy.association.Action;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.AppAssociationWriter;
import com.sun.deploy.association.utility.WinRegistryUtil;
import com.sun.deploy.model.LocalApplicationProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WinAppAssociationWriter
implements AppAssociationWriter {
    public WinAppAssociationWriter(LocalApplicationProperties lap) {
    }

    private void restoreAssociationRegistration(BackupAssociation backupAssoc, int regLevel) {
        try {
            String curMimeType = backupAssoc.getCurMimeType();
            if (!backupAssoc.getCurMimeTypeExisted()) {
                if (curMimeType != null) {
                    WinRegistryUtil.removeMimeType(curMimeType, regLevel);
                }
            } else {
                String backupFileExt = backupAssoc.getBackupFileExt();
                if (backupFileExt != null) {
                    WinRegistryUtil.setFileExtByMimeType(backupFileExt, curMimeType, regLevel);
                }
            }
            int numExts = backupAssoc.getNumFileExts();
            for (int i = 0; i < numExts; ++i) {
                String backupClassID;
                String curFileExt = backupAssoc.getCurFileExt(i);
                if (!backupAssoc.getCurFileExtExisted(i)) {
                    if (curFileExt == null) continue;
                    WinRegistryUtil.removeFileExt(curFileExt, regLevel);
                    continue;
                }
                String backupMimeType = backupAssoc.getBackupMimeType(i);
                if (backupMimeType != null) {
                    WinRegistryUtil.setMimeTypeByFileExt(backupMimeType, curFileExt, regLevel);
                }
                if ((backupClassID = backupAssoc.getBackupClassID(i)) == null) continue;
                WinRegistryUtil.setClassIDByFileExt(curFileExt, backupClassID, regLevel);
            }
        }
        catch (RegisterFailedException registerFailedException) {
            // empty catch block
        }
    }

    private void restoreAssociationUnregistration(BackupAssociation backupAssoc, int regLevel) {
        try {
            String curMimeType = backupAssoc.getCurMimeType();
            if (backupAssoc.getCurMimeTypeExisted()) {
                WinRegistryUtil.addMimeType(curMimeType, regLevel);
                String backupFileExt = backupAssoc.getBackupFileExt();
                if (backupFileExt != null) {
                    WinRegistryUtil.setFileExtByMimeType(backupFileExt, curMimeType, regLevel);
                }
            }
            int numExts = backupAssoc.getNumFileExts();
            for (int i = 0; i < numExts; ++i) {
                String curFileExt = backupAssoc.getCurFileExt(i);
                if (!backupAssoc.getCurFileExtExisted(i)) continue;
                WinRegistryUtil.addFileExt(curFileExt, regLevel);
                String backupMimeType = backupAssoc.getBackupMimeType(i);
                String backupClassID = backupAssoc.getBackupClassID(i);
                if (backupMimeType != null) {
                    WinRegistryUtil.setMimeTypeByFileExt(backupMimeType, curFileExt, regLevel);
                }
                if (backupClassID == null) continue;
                WinRegistryUtil.setClassIDByFileExt(curFileExt, backupClassID, regLevel);
            }
        }
        catch (RegisterFailedException registerFailedException) {
            // empty catch block
        }
    }

    @Override
    public void checkAssociationValidForRegistration(Association assoc) throws IllegalArgumentException {
        boolean isActionListEmpty = true;
        boolean isFileExtensionEmpty = true;
        boolean isValid = false;
        if (assoc.getActionList() != null) {
            isActionListEmpty = assoc.getActionList().isEmpty();
        }
        if (assoc.getFileExtList() != null) {
            isFileExtensionEmpty = assoc.getFileExtList().isEmpty();
        }
        if (!(isValid = isFileExtensionEmpty && assoc.getMimeType() == null ? false : (assoc.getDescription() != null || assoc.getIconFileName() != null || !isActionListEmpty ? !isFileExtensionEmpty : true))) {
            throw new IllegalArgumentException("The given association is invalid. It should specify both the mimeType and fileExtensionList fields to perform this operation.");
        }
    }

    @Override
    public void checkAssociationValidForUnregistration(Association assoc) throws IllegalArgumentException {
        boolean isFileExtListEmpty = true;
        if (assoc.getFileExtList() != null) {
            isFileExtListEmpty = assoc.getFileExtList().isEmpty();
        }
        if (assoc.getMimeType() == null && isFileExtListEmpty) {
            throw new IllegalArgumentException("The given association is invalid. It should specify both the mimeType and fileExtensionList fields to perform this operation.");
        }
    }

    @Override
    public boolean isAssociationExist(Association assoc, int regLevel) {
        String temFileExt;
        String temMimeType = assoc.getMimeType();
        Iterator<String> temFileExtIter = assoc.getFileExtList() != null ? assoc.getFileExtList().iterator() : null;
        if (temFileExtIter != null) {
            boolean isWin2kUserDefinedFileExt = true;
            while (isWin2kUserDefinedFileExt && temFileExtIter.hasNext()) {
                temFileExt = temFileExtIter.next();
                if (WinRegistryUtil.isWin2kUserDefinedFileExtExist(temFileExt)) continue;
                isWin2kUserDefinedFileExt = false;
            }
            if (isWin2kUserDefinedFileExt) {
                return true;
            }
        }
        temFileExtIter = assoc.getFileExtList() != null ? assoc.getFileExtList().iterator() : null;
        if (temMimeType == null && temFileExtIter == null) {
            return false;
        }
        if (temMimeType == null && temFileExtIter != null) {
            boolean isFileExtsExist = true;
            while (isFileExtsExist && temFileExtIter.hasNext()) {
                temFileExt = temFileExtIter.next();
                if (WinRegistryUtil.isFileExtExist(temFileExt, regLevel)) continue;
                isFileExtsExist = false;
            }
            return isFileExtsExist;
        }
        if (temMimeType != null && temFileExtIter == null) {
            return WinRegistryUtil.isMimeTypeExist(temMimeType, regLevel);
        }
        boolean fileExtMappingExists = WinRegistryUtil.isMimeTypeExist(temMimeType, regLevel);
        while (fileExtMappingExists && temFileExtIter.hasNext()) {
            temFileExt = temFileExtIter.next();
            String regMimeType = WinRegistryUtil.getMimeTypeByFileExt(temFileExt, regLevel);
            String regFileExt = WinRegistryUtil.getFileExtByMimeType(temMimeType, regLevel);
            fileExtMappingExists = WinRegistryUtil.isFileExtExist(temFileExt, regLevel) && (regFileExt == null ? temFileExt == null : regFileExt.contains(temFileExt)) && (temMimeType == null ? regMimeType == null : temMimeType.equals(regMimeType));
        }
        return fileExtMappingExists;
    }

    @Override
    public void registerAssociation(Association assoc, int regLevel) throws RegisterFailedException {
        boolean isOldWindows = false;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("98") != -1 || osName.indexOf("me") != -1 || osName.indexOf("nt") != -1) {
            isOldWindows = true;
        }
        if (isOldWindows) {
            regLevel = 2;
        }
        BackupAssociation backupAssoc = new BackupAssociation(assoc, regLevel);
        String curMimeType = backupAssoc.getCurMimeType();
        String curDescription = assoc.getDescription();
        String curIconFileName = assoc.getIconFileName();
        List<Action> curActionList = assoc.getActionList();
        boolean curMimeTypeExisted = backupAssoc.getCurMimeTypeExisted();
        try {
            int numFileExts = backupAssoc.getNumFileExts();
            for (int i = 0; i < numFileExts; ++i) {
                String curFileExt = backupAssoc.getCurFileExt(i);
                boolean curFileExtExisted = backupAssoc.getCurFileExtExisted(i);
                if (curMimeType == null && curFileExt != null) {
                    WinRegistryUtil.addFileExt(curFileExt, regLevel);
                    if (curDescription != null) {
                        WinRegistryUtil.setDescriptionByFileExt(curDescription, curFileExt, regLevel);
                    }
                    if (curIconFileName != null) {
                        WinRegistryUtil.setIconFileNameByFileExt(curIconFileName, curFileExt, regLevel);
                    }
                    if (curActionList != null) {
                        WinRegistryUtil.setActionListByFileExt(curActionList, curFileExt, regLevel);
                    }
                    WinRegistryUtil.markGeneratorByFileExt(curFileExt, regLevel);
                    continue;
                }
                if (curMimeType != null && curFileExt == null) {
                    WinRegistryUtil.addMimeType(curMimeType, regLevel);
                    continue;
                }
                if (curMimeType == null || curFileExt == null) continue;
                if (!curMimeTypeExisted) {
                    WinRegistryUtil.addMimeType(curMimeType, regLevel);
                }
                if (!curFileExtExisted) {
                    WinRegistryUtil.addFileExt(curFileExt, regLevel);
                }
                if (curDescription != null) {
                    WinRegistryUtil.setDescriptionByFileExt(curDescription, curFileExt, regLevel);
                }
                if (curIconFileName != null) {
                    WinRegistryUtil.setIconFileNameByFileExt(curIconFileName, curFileExt, regLevel);
                }
                if (curActionList != null) {
                    WinRegistryUtil.setActionListByFileExt(curActionList, curFileExt, regLevel);
                }
                WinRegistryUtil.markGeneratorByFileExt(curFileExt, regLevel);
                WinRegistryUtil.addMutualRef(curFileExt, curMimeType, regLevel);
            }
        }
        catch (RegisterFailedException e) {
            this.restoreAssociationRegistration(backupAssoc, regLevel);
            throw e;
        }
    }

    @Override
    public void unregisterAssociation(Association assoc, int regLevel) throws RegisterFailedException {
        boolean isOldWindows = false;
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("98") != -1 || osName.indexOf("me") != -1 || osName.indexOf("nt") != -1) {
            isOldWindows = true;
        }
        if (isOldWindows) {
            regLevel = 2;
        }
        BackupAssociation backupAssoc = new BackupAssociation(assoc, regLevel);
        String curMimeType = backupAssoc.getCurMimeType();
        boolean curMimeTypeExisted = backupAssoc.getCurMimeTypeExisted();
        try {
            int numExts = backupAssoc.getNumFileExts();
            for (int i = 0; i < numExts; ++i) {
                String curFileExt = backupAssoc.getCurFileExt(i);
                boolean curFileExtExisted = backupAssoc.getCurFileExtExisted(i);
                if (curMimeTypeExisted) {
                    WinRegistryUtil.removeMimeType(curMimeType, regLevel);
                }
                if (!curFileExtExisted) continue;
                WinRegistryUtil.removeFileExt(curFileExt, regLevel);
            }
        }
        catch (RegisterFailedException e) {
            this.restoreAssociationUnregistration(backupAssoc, regLevel);
            throw e;
        }
    }

    protected class BackupAssociation {
        private String curMimeType;
        private List<String> fileExts;
        private boolean curMimeTypeExisted;
        private boolean[] fileExtExisted;
        private String[] backupMimeType;
        private String[] backupClassID;
        private String backupFileExt;

        private BackupAssociation() {
        }

        protected BackupAssociation(Association assoc, int regLevel) {
            this.curMimeType = assoc.getMimeType();
            List<String> temFileExtList = assoc.getFileExtList();
            if (temFileExtList != null) {
                this.fileExts = new ArrayList<String>();
                this.fileExts.addAll(temFileExtList);
            }
            this.curMimeTypeExisted = this.curMimeType != null ? WinRegistryUtil.isMimeTypeExist(this.curMimeType, regLevel) : false;
            if (this.fileExts != null) {
                int numExts = this.fileExts.size();
                this.fileExtExisted = new boolean[numExts];
                this.backupClassID = new String[numExts];
                this.backupMimeType = new String[numExts];
                for (int i = 0; i < numExts; ++i) {
                    String curFileExt = this.fileExts.get(i);
                    this.fileExtExisted[i] = WinRegistryUtil.isFileExtExist(curFileExt, regLevel);
                    this.backupClassID[i] = WinRegistryUtil.getClassIDByFileExt(curFileExt, regLevel);
                    this.backupMimeType[i] = WinRegistryUtil.getMimeTypeByFileExt(curFileExt, regLevel);
                }
            } else {
                this.fileExtExisted = null;
            }
            if (this.curMimeTypeExisted) {
                this.backupFileExt = WinRegistryUtil.getFileExtByMimeType(this.curMimeType, regLevel);
            }
        }

        protected String getCurMimeType() {
            return this.curMimeType;
        }

        protected String getCurFileExt(int i) {
            return this.fileExts.get(i);
        }

        int getNumFileExts() {
            return this.fileExts == null ? 0 : this.fileExts.size();
        }

        protected boolean getCurMimeTypeExisted() {
            return this.curMimeTypeExisted;
        }

        protected boolean getCurFileExtExisted(int i) {
            return this.fileExtExisted[i];
        }

        protected String getBackupMimeType(int i) {
            return this.backupMimeType[i];
        }

        protected String getBackupClassID(int i) {
            return this.backupClassID[i];
        }

        protected String getBackupFileExt() {
            return this.backupFileExt;
        }
    }
}

