/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.SystemUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class CacheUpgradeHelper {
    private static final boolean DEBUG = Config.getDebug();
    private static List<CacheUpgradeHelper> helpers = new ArrayList<CacheUpgradeHelper>();

    protected synchronized void register() {
        if (!helpers.contains(this)) {
            helpers.add(this);
        }
    }

    public static void upgradeLocalAppProperties(CacheEntry newEntry, CacheEntry oldEntry) {
        for (int i = 0; i < helpers.size(); ++i) {
            CacheUpgradeHelper helper = helpers.get(i);
            if (!helper.canProcess(oldEntry.getCacheVersion())) continue;
            helper.processLocalAppProperties(newEntry, oldEntry);
        }
    }

    public abstract void processLocalAppProperties(CacheEntry var1, CacheEntry var2);

    public boolean canProcess(int cacheVersion) {
        return true;
    }

    protected static Properties loadProperties(File lapFile) {
        try {
            Properties props = new Properties();
            props.load(new ByteArrayInputStream(Cache.getLapBytes(lapFile)));
            return props;
        }
        catch (IOException ioe) {
            Trace.ignoredException(ioe);
            return null;
        }
    }

    protected static String getLapFileName(CacheEntry ce) {
        return ce.getResourceFilename() + "6.0" + Cache.getVersionTag(ce.getVersion()) + ".lap";
    }

    protected static Properties getProperties(CacheEntry oldEntry) {
        File lapFile = new File(CacheUpgradeHelper.getLapFileName(oldEntry));
        if (lapFile.isFile()) {
            return CacheUpgradeHelper.loadProperties(lapFile);
        }
        return null;
    }

    static String getHelperJarPaths() {
        StringBuffer paths = new StringBuffer();
        for (int i = 0; i < helpers.size(); ++i) {
            String path = SystemUtils.getJarPath(helpers.get(i).getClass());
            if (DEBUG && !new File(path).exists()) {
                System.out.println("Wrong path: " + path);
            }
            paths.append(path);
            paths.append(File.pathSeparator);
        }
        return paths.toString();
    }
}

