/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.BaseLocalApplicationProperties;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

public class DefaultLocalApplicationProperties
extends BaseLocalApplicationProperties {
    private long _lastAccessed;
    private boolean _dirty;
    private LocalApplicationProperties.Kind _kind;

    public DefaultLocalApplicationProperties(URL location, String versionId, boolean isApplicationDescriptor) {
        this(location, versionId, isApplicationDescriptor, Environment.isSystemCacheMode() ? LocalApplicationProperties.Kind.SYSTEM : LocalApplicationProperties.Kind.LOCAL);
    }

    public DefaultLocalApplicationProperties(URL location, String versionId, boolean isApplicationDescriptor, LocalApplicationProperties.Kind kind) {
        super(location, versionId, isApplicationDescriptor);
        this._kind = kind;
        this._properties = this.getLocalApplicationPropertiesStorage(this);
    }

    private void putLocalApplicationPropertiesStorage(DefaultLocalApplicationProperties lap, Properties props) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            props.store(bos, "LAP");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        bos.close();
        char type = lap.isApplicationDescriptor() ? (char)'A' : 'E';
        Cache.putLapData(type, lap.getLocation(), lap.getVersionId(), bos.toByteArray(), this._kind);
        this._lastAccessed = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
        synchronized (defaultLocalApplicationProperties) {
            Properties props;
            this._properties = props = this.getLocalApplicationPropertiesStorage(this);
            this._dirty = false;
        }
    }

    private Properties getLocalApplicationPropertiesStorage(DefaultLocalApplicationProperties lap) {
        Properties props = new Properties();
        try {
            URL url = lap.getLocation();
            String versionId = lap.getVersionId();
            if (url != null) {
                char type = lap.isApplicationDescriptor() ? (char)'A' : 'E';
                byte[] data = Cache.getLapData(type, url, versionId, LocalApplicationProperties.Kind.SYSTEM);
                if (data != null) {
                    props.load(new ByteArrayInputStream(data));
                    String value = (String)props.get("locallyInstalled");
                    if (value != null) {
                        this._isShortcutInstalledSystem = Boolean.valueOf(value);
                    }
                }
                if ((data = Cache.getLapData(type, url, versionId, this._kind)) != null) {
                    props.load(new ByteArrayInputStream(data));
                }
                this._lastAccessed = System.currentTimeMillis();
            }
        }
        catch (IOException ioe) {
            Trace.ignoredException(ioe);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesNewVersionExist() {
        DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
        synchronized (defaultLocalApplicationProperties) {
            long cache = Cache.getLastAccessed(Environment.isSystemCacheMode());
            if (cache == 0L) {
                return false;
            }
            if (cache > this._lastAccessed) {
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized void store() throws IOException {
        this.putLocalApplicationPropertiesStorage(this, this._properties);
        this._dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshIfNecessary() {
        DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
        synchronized (defaultLocalApplicationProperties) {
            if (!this._dirty && this.doesNewVersionExist()) {
                this.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, String value) {
        DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
        synchronized (defaultLocalApplicationProperties) {
            this._dirty = true;
            super.put(key, value);
        }
    }
}

