/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.nativesandbox;

import com.sun.deploy.nativesandbox.NativeSandboxBroker;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;

public class NoSandboxBroker
implements NativeSandboxBroker {
    private static final boolean TRACE = false;
    private static final int BUF_SIZE = 32768;
    private static final AccessControlContext ACC_FILE_INSTANCE;

    @Override
    public boolean writeFile(String path, byte[] data, long offset, boolean append) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeFile(File file, byte[] data) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        BufferedOutputStream bof = new BufferedOutputStream(new FileOutputStream(file));
        byte[] buffer = new byte[32768];
        try {
            int n = is.read(buffer);
            while (n >= 0) {
                bof.write(buffer, 0, n);
                n = is.read(buffer);
            }
        }
        finally {
            bof.close();
            ((InputStream)is).close();
        }
        return true;
    }

    @Override
    public boolean writeFile(RandomAccessFile raf, File file, long offset, byte[] data) throws IOException {
        if (raf == null) {
            return false;
        }
        raf.seek(offset);
        raf.write(data);
        return true;
    }

    @Override
    public boolean deleteFile(File file) {
        if (file != null && file.exists()) {
            return file.delete();
        }
        return false;
    }

    @Override
    public boolean deleteOnExitFile(File file) {
        if (file != null && file.exists()) {
            file.deleteOnExit();
        }
        return true;
    }

    @Override
    public boolean renameFile(final File fromFile, final String toPath) {
        if (fromFile == null || toPath == null) {
            return false;
        }
        Boolean b = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return fromFile.renameTo(new File(toPath));
            }
        }, ACC_FILE_INSTANCE);
        return b;
    }

    @Override
    public OutputStream getOutputStream(File file, boolean overwrite) throws IOException {
        if (file == null) {
            return null;
        }
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    @Override
    public boolean showDocument(String url) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String openFileDialog(String pathHint, String[] extensions) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] openMultiFileDialog(String pathHint, String[] extensions) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String saveFile(String pathHint, String[] extensions, String filename) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NativeSandboxBroker.RAF sendRAF(NativeSandboxBroker.RAF raf) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean openFile(String file) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean openFiles(String[] files) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeAssociation(String mimetype, String[] extensions) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean removeShortcuts() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean requestAssociation(String mimetype, String[] extensions) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean requestShortcut(boolean desktop, boolean menu, String submenu) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long createMuffin(String url, long maxsize) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void deleteMuffin(String url) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getMuffin(String url) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMuffinTag(String url, int tag) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean parentWindow(int appletID, long child) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean setProperty(int value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        Permissions perms = new Permissions();
        FilePermission perm = new FilePermission("<<ALL FILES>>", "read,write,delete");
        ((PermissionCollection)perms).add(perm);
        ACC_FILE_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
    }
}

