/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.security.ImmutableCertStore;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import java.util.TreeSet;

public final class DeploySSLCertStore
implements CertStore {
    private static String _userFilename = null;
    private static String _systemFilename = null;
    private long _userLastModified = 0L;
    private long _sysLastModified = 0L;
    private KeyStore _deploymentUserCerts = CertUtils.createEmptyKeyStore();
    private KeyStore _deploymentSystemCerts = CertUtils.createEmptyKeyStore();
    private char[] keyPassphrase = new char[0];
    private boolean cancelFlag = false;
    private int certStoreType = 0;

    private DeploySSLCertStore(int storeType) {
        this.certStoreType = storeType;
    }

    public static CertStore getCertStore() {
        return new ImmutableCertStore(new DeploySSLCertStore(3));
    }

    public static CertStore getUserCertStore() {
        return new DeploySSLCertStore(1);
    }

    public static CertStore getSystemCertStore() {
        return new ImmutableCertStore(new DeploySSLCertStore(2));
    }

    @Override
    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.load(false);
    }

    @Override
    public void load(boolean integrityCheck) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        long lastModified;
        if ((this.certStoreType & 1) == 1 && _userFilename != null && (lastModified = CertUtils.getFileLastModified(_userFilename)) != this._userLastModified) {
            this._deploymentUserCerts = this.loadCertStore(_userFilename, integrityCheck);
            this._userLastModified = lastModified;
        }
        if ((this.certStoreType & 2) == 2 && _systemFilename != null && (lastModified = CertUtils.getFileLastModified(_systemFilename)) != this._sysLastModified) {
            this._deploymentSystemCerts = this.loadCertStore(_systemFilename, integrityCheck);
            this._sysLastModified = lastModified;
        }
    }

    private KeyStore loadCertStore(String filename, final boolean integrityCheck) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("httpscertstore.cert.loading", new Object[]{filename});
        final File file = new File(filename);
        final KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    if (file.exists()) {
                        FileInputStream fis = new FileInputStream(file);
                        BufferedInputStream bis = new BufferedInputStream(fis);
                        if (integrityCheck) {
                            DeploySSLCertStore.this.cancelFlag = false;
                            keyStore.load(bis, new char[0]);
                        } else {
                            keyStore.load(bis, null);
                        }
                        bis.close();
                        fis.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (ex instanceof IOException) {
                if (integrityCheck) {
                    FileInputStream fis = new FileInputStream(file);
                    BufferedInputStream bis = new BufferedInputStream(fis);
                    CredentialInfo passwordInfo = ToolkitStore.getUI().showPasswordDialog(null, ResourceManager.getString("password.dialog.title"), ResourceManager.getString("httpscertstore.password.dialog.text"), false, false, null, false, null);
                    if (passwordInfo != null) {
                        this.cancelFlag = false;
                        this.keyPassphrase = passwordInfo.getPassword();
                        keyStore.load(bis, this.keyPassphrase);
                    } else {
                        this.cancelFlag = true;
                    }
                    bis.close();
                    fis.close();
                }
                throw (IOException)ex;
            }
            if (ex instanceof CertificateException) {
                throw (CertificateException)ex;
            }
            if (ex instanceof KeyStoreException) {
                throw (KeyStoreException)ex;
            }
            if (ex instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ex;
            }
            Trace.securityPrintException(e);
        }
        Trace.msgSecurityPrintln("httpscertstore.cert.loaded", new Object[]{filename});
        return keyStore;
    }

    @Override
    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("httpscertstore.cert.saving", new Object[]{_userFilename});
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file = new File(_userFilename);
                    file.getParentFile().mkdirs();
                    FileOutputStream fos = new FileOutputStream(file);
                    BufferedOutputStream bos = new BufferedOutputStream(fos);
                    DeploySSLCertStore.this._deploymentUserCerts.store(bos, DeploySSLCertStore.this.keyPassphrase);
                    bos.close();
                    fos.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof CertificateException) {
                throw (CertificateException)ex;
            }
            if (ex instanceof KeyStoreException) {
                throw (KeyStoreException)ex;
            }
            if (ex instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)ex;
            }
            Trace.securityPrintException(e);
        }
        Trace.msgSecurityPrintln("httpscertstore.cert.saved", new Object[]{_userFilename});
    }

    @Override
    public boolean add(Certificate cert) throws KeyStoreException {
        return this.add(cert, null, false);
    }

    @Override
    public boolean add(Certificate cert, String loc, boolean tsFlag) throws KeyStoreException {
        Trace.msgSecurityPrintln("httpscertstore.cert.adding");
        if (this.cancelFlag) {
            return false;
        }
        String newAlias = this._deploymentUserCerts.getCertificateAlias(cert);
        if (newAlias == null) {
            Random rand = new Random();
            boolean found = false;
            String alias = null;
            do {
                Certificate c;
                if ((c = this._deploymentUserCerts.getCertificate(alias = "deploymentuserhttpscert" + rand.nextLong())) != null) continue;
                found = true;
            } while (!found);
            this._deploymentUserCerts.setCertificateEntry(alias, cert);
            Trace.msgSecurityPrintln("httpscertstore.cert.added", new Object[]{alias});
        }
        return true;
    }

    @Override
    public boolean remove(Certificate cert) throws IOException, KeyStoreException {
        Trace.msgSecurityPrintln("httpscertstore.cert.removing");
        if (this.cancelFlag) {
            return false;
        }
        String alias = this._deploymentUserCerts.getCertificateAlias(cert);
        if (alias != null) {
            this._deploymentUserCerts.deleteEntry(alias);
        }
        Trace.msgSecurityPrintln("httpscertstore.cert.removed", new Object[]{alias});
        return true;
    }

    @Override
    public boolean contains(Certificate cert) throws KeyStoreException {
        return this.contains(cert, null, false);
    }

    @Override
    public boolean contains(Certificate cert, String loc, boolean tsFlag) throws KeyStoreException {
        Trace.msgSecurityPrintln("httpscertstore.cert.instore");
        String alias = null;
        alias = this._deploymentSystemCerts.getCertificateAlias(cert);
        if (alias != null) {
            return true;
        }
        alias = this._deploymentUserCerts.getCertificateAlias(cert);
        return alias != null;
    }

    @Override
    public boolean verify(Certificate cert) {
        Trace.msgSecurityPrintln("httpscertstore.cert.canverify");
        return false;
    }

    @Override
    public Collection<X509Certificate> getCertificates() throws KeyStoreException {
        HashSet<X509Certificate> deploySSLCerts = new HashSet<X509Certificate>();
        if ((this.certStoreType & 1) == 1) {
            deploySSLCerts.addAll(this.getCertificates(1));
        }
        if ((this.certStoreType & 2) == 2) {
            deploySSLCerts.addAll(this.getCertificates(2));
        }
        return deploySSLCerts;
    }

    private Collection<X509Certificate> getCertificates(int myCertStoreType) throws KeyStoreException {
        Trace.msgSecurityPrintln("httpscertstore.cert.getcertificates");
        ArrayList<X509Certificate> certCollection = new ArrayList<X509Certificate>();
        KeyStore ks = null;
        ks = myCertStoreType == 1 ? this._deploymentUserCerts : this._deploymentSystemCerts;
        Enumeration<String> keyAliases = ks.aliases();
        TreeSet<String> tsCerts = new TreeSet<String>();
        while (keyAliases.hasMoreElements()) {
            String alias = keyAliases.nextElement();
            tsCerts.add(alias);
        }
        for (String sortAlias : tsCerts) {
            X509Certificate cert = (X509Certificate)ks.getCertificate(sortAlias);
            certCollection.add(cert);
        }
        return certCollection;
    }

    static {
        _userFilename = Config.getUserTrustedHttpsCertificateFile();
        _systemFilename = Config.getSystemTrustedHttpsCertificateFile();
    }
}

