/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.CertStore;
import com.sun.deploy.trace.Trace;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.PropertyPermission;
import java.util.Set;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.provider.certpath.DistributionPointFetcher;
import sun.security.provider.certpath.OCSP;
import sun.security.x509.X509CRLEntryImpl;

class RevocationChecker {
    private final X509Certificate anchor;
    private final Date date;
    private final String sigProvider;
    private final boolean checkOCSP;
    private final boolean checkCRLs;
    private final boolean checkBoth;
    private URI ocspResponderURI;
    private final X509Certificate ocspResponderCert;
    private final boolean onlyPublisher;
    private final X509CRL configCrl;
    private final Date timestamp;
    private long maxClockSkew = 900000L;
    private X509Certificate issuerCert;
    private boolean certCanSignCRL = true;
    private String variant;
    private static final AccessControlContext ACC_PROP_INSTANCE;
    private static final boolean[] ALL_REASONS;
    private static Class<?>[] PARAMS;
    private static Class<?>[] TYPES;

    RevocationChecker(X509Certificate anchor, PKIXParameters params, final boolean checkOCSP, final boolean checkCRLs, String ocspResponder, X509Certificate ocspResponderCert, boolean onlyPublisher, X509CRL configCrl, Date timestamp, final String timeout, final String clockSkew, String variant) {
        if (!checkOCSP && !checkCRLs) {
            throw new IllegalArgumentException();
        }
        this.date = params.getDate();
        this.sigProvider = params.getSigProvider();
        this.anchor = anchor;
        this.issuerCert = anchor;
        this.checkOCSP = checkOCSP;
        this.checkCRLs = checkCRLs;
        this.checkBoth = checkOCSP && checkCRLs;
        this.variant = variant;
        if (ocspResponder != null) {
            try {
                this.ocspResponderURI = new URI(ocspResponder);
            }
            catch (URISyntaxException use) {
                Trace.securityPrintln("Can't parse OCSP responder URI: " + this.ocspResponderURI);
                Trace.ignored(use);
            }
        }
        this.ocspResponderCert = ocspResponderCert;
        this.onlyPublisher = onlyPublisher;
        this.configCrl = configCrl;
        this.timestamp = timestamp;
        if (clockSkew != null) {
            try {
                this.maxClockSkew = Long.parseLong(clockSkew);
            }
            catch (NumberFormatException nfe) {
                Trace.ignored(nfe);
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (checkOCSP) {
                    if (timeout != null) {
                        System.setProperty("com.sun.security.ocsp.timeout", timeout);
                    }
                    if (clockSkew != null) {
                        System.setProperty("com.sun.security.ocsp.clockSkew", clockSkew);
                    }
                }
                if (checkCRLs) {
                    System.setProperty("com.sun.security.enableCRLDP", "true");
                    if (timeout != null) {
                        System.setProperty("com.sun.security.crl.timeout", timeout);
                    }
                    System.setProperty("sun.security.certpath.ldap.disable.app.resource.files", "true");
                }
                return null;
            }
        }, ACC_PROP_INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void check(X509Certificate cert, boolean certExpired) throws CertificateException {
        try {
            if (this.onlyPublisher && cert.getBasicConstraints() != -1) {
                Trace.securityPrintln("Skipping revocation check, not publisher cert");
                return;
            }
            if (this.checkOCSP) {
                this.checkOCSP(cert);
            } else if (this.checkCRLs) {
                this.checkCRLs(cert, certExpired);
            }
        }
        catch (CertificateException ce) {
            if (!this.checkBoth || ce instanceof CertificateRevokedException) {
                throw ce;
            }
            CertificateException cause = ce;
            Trace.securityPrintln("Failing over to CRLs: " + ce.getMessage());
            try {
                this.checkCRLs(cert, certExpired);
            }
            catch (CertificateException ce2) {
                if (ce2 instanceof CertificateRevokedException) {
                    throw ce2;
                }
                cause.addSuppressed(ce2);
                throw cause;
            }
        }
        finally {
            this.updateState(cert);
        }
    }

    private void updateState(X509Certificate cert) {
        this.issuerCert = cert;
        this.certCanSignCRL = RevocationChecker.certCanSignCRL(cert);
    }

    private static boolean certCanSignCRL(X509Certificate cert) {
        boolean[] keyUsage = cert.getKeyUsage();
        if (keyUsage != null) {
            return keyUsage[6];
        }
        return false;
    }

    private void checkOCSP(X509Certificate cert) throws CertificateException {
        URI responder;
        URI uRI = responder = this.ocspResponderURI != null ? this.ocspResponderURI : OCSP.getResponderURI(cert);
        if (responder == null) {
            throw new StatusUnknownException("Certificate does not specify OCSP responder");
        }
        X509Certificate responderCert = this.ocspResponderCert != null ? this.ocspResponderCert : this.issuerCert;
        try {
            OCSP.RevocationStatus rs = this.doPrivilegedOCSPCheck(cert, responder, responderCert);
            Trace.securityPrintln("OCSP Response: " + rs.getCertStatus());
            if (rs.getCertStatus() == OCSP.RevocationStatus.CertStatus.REVOKED) {
                throw new CertificateRevokedException(rs.getRevocationTime(), rs.getRevocationReason(), responderCert.getSubjectX500Principal(), rs.getSingleExtensions());
            }
            if (rs.getCertStatus() == OCSP.RevocationStatus.CertStatus.UNKNOWN) {
                throw new StatusUnknownException();
            }
        }
        catch (PrivilegedActionException pae) {
            Throwable paeCause = pae.getCause();
            if (paeCause instanceof IOException) {
                throw new StatusUnknownException(paeCause);
            }
            if (paeCause instanceof CertPathValidatorException) {
                Throwable cpveCause;
                String responseError = "OCSP response error: ";
                String message = paeCause.getMessage();
                if (message != null && message.startsWith(responseError)) {
                    String error = message.substring(responseError.length());
                    Trace.securityPrintln(error);
                    if (error.equals("UNAUTHORIZED") || error.equals("TRY_LATER") || error.equals("INTERNAL_ERROR")) {
                        throw new StatusUnknownException(paeCause);
                    }
                }
                if ((cpveCause = paeCause.getCause()) != null && cpveCause instanceof IOException) {
                    throw new StatusUnknownException(cpveCause);
                }
                throw new CertificateException(paeCause);
            }
            throw new CertificateException(paeCause);
        }
    }

    private OCSP.RevocationStatus doPrivilegedOCSPCheck(final X509Certificate cert, final URI responder, final X509Certificate responderCert) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<OCSP.RevocationStatus>(){

            @Override
            public OCSP.RevocationStatus run() throws CertPathValidatorException, IOException {
                try {
                    return OCSP.check((X509Certificate)cert, (X509Certificate)RevocationChecker.this.issuerCert, (URI)responder, (X509Certificate)responderCert, (Date)RevocationChecker.this.date, Collections.emptyList(), (String)RevocationChecker.this.variant);
                }
                catch (NoSuchMethodError nme) {
                    return OCSP.check((X509Certificate)cert, (X509Certificate)RevocationChecker.this.issuerCert, (URI)responder, (X509Certificate)responderCert, (Date)RevocationChecker.this.date);
                }
            }
        });
    }

    private void checkCRLs(X509Certificate cert, boolean certExpired) throws CertificateException {
        X509CRLSelector crlSelector = new X509CRLSelector();
        crlSelector.setCertificateChecking(cert);
        try {
            CertPathHelper.setDateAndTime(crlSelector, this.date, this.maxClockSkew);
        }
        catch (IllegalAccessError iae) {
            RevocationChecker.setDateAndTime(crlSelector, this.date, this.maxClockSkew);
        }
        boolean[] reasonsMask = new boolean[9];
        Set<TrustAnchor> anchors = Collections.singleton(new TrustAnchor(this.anchor, null));
        Collection<Object> crls = null;
        if (this.configCrl != null) {
            crls = new HashSet<X509CRL>();
            crls.add(this.configCrl);
        } else {
            try {
                crls = this.getCRLsPrivileged(crlSelector, reasonsMask, anchors);
            }
            catch (PrivilegedActionException pae) {
                Throwable paeCause = pae.getCause();
                if (paeCause instanceof CertStoreException) {
                    for (Throwable cseCause = paeCause.getCause(); cseCause != null; cseCause = cseCause.getCause()) {
                        if (!(cseCause instanceof IOException)) continue;
                        throw new StatusUnknownException(paeCause);
                    }
                    throw new CertificateException(paeCause);
                }
                throw new CertificateException(paeCause);
            }
            catch (IllegalAccessError iae) {
                crls = RevocationChecker.getCRLs(crlSelector, this.certCanSignCRL, this.issuerCert.getPublicKey(), this.sigProvider, Collections.emptyList(), reasonsMask, anchors, this.date);
            }
        }
        if (!crls.isEmpty() && Arrays.equals(reasonsMask, ALL_REASONS)) {
            this.checkApprovedCRLs(cert, crls);
            if (certExpired) {
                throw new StatusUnknownException();
            }
        } else {
            throw new StatusUnknownException();
        }
    }

    private Collection<X509CRL> getCRLsPrivileged(final X509CRLSelector crlSelector, final boolean[] reasonsMask, final Set<TrustAnchor> anchors) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Collection<X509CRL>>(){

            @Override
            public Collection<X509CRL> run() throws CertStoreException {
                try {
                    return DistributionPointFetcher.getCRLs((X509CRLSelector)crlSelector, (boolean)RevocationChecker.this.certCanSignCRL, (PublicKey)RevocationChecker.this.issuerCert.getPublicKey(), null, (String)RevocationChecker.this.sigProvider, Collections.emptyList(), (boolean[])reasonsMask, (Set)anchors, (Date)RevocationChecker.this.date, (String)RevocationChecker.this.variant);
                }
                catch (NoSuchMethodError nsme) {
                    return DistributionPointFetcher.getCRLs((X509CRLSelector)crlSelector, (boolean)RevocationChecker.this.certCanSignCRL, (PublicKey)RevocationChecker.this.issuerCert.getPublicKey(), (String)RevocationChecker.this.sigProvider, Collections.emptyList(), (boolean[])reasonsMask, (Set)anchors, (Date)RevocationChecker.this.date);
                }
            }
        });
    }

    private static void setDateAndTime(final X509CRLSelector sel, final Date date, final long skew) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Class<?> cl = Class.forName("sun.security.provider.certpath.CertPathHelper");
                    Method m = cl.getDeclaredMethod("setDateAndTime", PARAMS);
                    m.setAccessible(true);
                    m.invoke(null, sel, date, skew);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Trace.ignored(pae);
            sel.setDateAndTime(date);
        }
    }

    private static Collection<X509CRL> getCRLs(final X509CRLSelector selector, final boolean signFlag, final PublicKey prevKey, final String provider, final List<CertStore> certStores, final boolean[] reasonsMask, final Set<TrustAnchor> trustAnchors, final Date validity) throws StatusUnknownException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Collection<X509CRL>>(){

                @Override
                public Collection<X509CRL> run() throws Exception {
                    Class<?> cl = Class.forName("sun.security.provider.certpath.DistributionPointFetcher");
                    Method m = cl.getDeclaredMethod("getInstance", null);
                    m.setAccessible(true);
                    Object dpf = m.invoke(null, new Object[0]);
                    m = cl.getDeclaredMethod("getCRLs", TYPES);
                    m.setAccessible(true);
                    return (Collection)m.invoke(dpf, selector, signFlag, prevKey, provider, certStores, reasonsMask, trustAnchors, validity);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Trace.ignored(pae);
            throw new StatusUnknownException();
        }
    }

    private void checkApprovedCRLs(X509Certificate cert, Collection<X509CRL> approvedCRLs) throws CertificateException {
        X509CRLEntryImpl entry = null;
        for (X509CRL crl : approvedCRLs) {
            CRLReason reasonCode;
            X509CRLEntry e = crl.getRevokedCertificate(cert);
            if (e == null) continue;
            try {
                entry = X509CRLEntryImpl.toImpl(e);
            }
            catch (CRLException ce) {
                throw new CertificateException(ce);
            }
            Set<String> unresCritExts = entry.getCriticalExtensionOIDs();
            if (unresCritExts != null && !unresCritExts.isEmpty()) {
                unresCritExts.remove("2.5.29.21");
                unresCritExts.remove("2.5.29.29");
                if (!unresCritExts.isEmpty()) {
                    throw new CertificateException("unresolved critical extensions in CRLEntry");
                }
            }
            if ((reasonCode = entry.getRevocationReason()) == null) {
                reasonCode = CRLReason.UNSPECIFIED;
            }
            Date revocationDate = entry.getRevocationDate();
            throw new CertificateRevokedException(revocationDate, reasonCode, crl.getIssuerX500Principal(), entry.getExtensions());
        }
    }

    static {
        Permissions perms = new Permissions();
        PropertyPermission perm = new PropertyPermission("*", "read,write");
        ((PermissionCollection)perms).add(perm);
        ACC_PROP_INSTANCE = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, perms)});
        ALL_REASONS = new boolean[]{true, true, true, true, true, true, true, true, true};
        PARAMS = new Class[]{X509CRLSelector.class, Date.class, Long.TYPE};
        TYPES = new Class[]{X509CRLSelector.class, Boolean.TYPE, PublicKey.class, String.class, List.class, boolean[].class, Set.class, Date.class};
    }

    static class StatusUnknownException
    extends CertificateException {
        static final long serialVersionUID = -1133298886602198899L;

        StatusUnknownException() {
        }

        StatusUnknownException(String msg) {
            super(msg);
        }

        StatusUnknownException(Throwable t) {
            super(t);
        }
    }
}

