/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.util.SessionProperties;
import com.sun.deploy.util.SessionState;
import com.sun.deploy.util.URLUtil;
import java.net.URL;

public class TrustRecorder {
    protected static final String FILENAME = "trust.recorder.props";
    private static String ALLP_PREFIX = "trust.allperms.";
    private static String SAND_PREFIX = "trust.sandbox.";
    private static String ALLSIGNED_PREFIX = "trust.all.signed.";
    private static SessionProperties recordedProps = new SessionProperties("trust.recorder.props");

    public static void grant(URL url, boolean allPerms) {
        String key = (allPerms ? ALLP_PREFIX : SAND_PREFIX) + URLUtil.urlNoFragString(url);
        recordedProps.setProperty(key, "true");
    }

    public static boolean isGranted(URL url, boolean allPerms) {
        String key = (allPerms ? ALLP_PREFIX : SAND_PREFIX) + URLUtil.urlNoFragString(url);
        return "true".equals(recordedProps.getProperty(key));
    }

    public static void recordAllSigned(URL url, boolean allSigned) {
        if (url != null) {
            String key = ALLSIGNED_PREFIX + URLUtil.urlNoFragString(url);
            recordedProps.setProperty(key, allSigned ? "true" : "false");
        }
    }

    public static boolean isAllSigned(URL url) {
        if (url != null) {
            String key = ALLSIGNED_PREFIX + URLUtil.urlNoFragString(url);
            return "true".equals(recordedProps.getProperty(key));
        }
        return false;
    }

    public static boolean isNotAllSigned(URL url) {
        if (url != null) {
            String key = ALLSIGNED_PREFIX + URLUtil.urlNoFragString(url);
            return "false".equals(recordedProps.getProperty(key));
        }
        return false;
    }

    static {
        SessionState.register(recordedProps);
    }
}

