/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security.ruleset;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.ref.AppRef;
import com.sun.deploy.ref.CodeInstance;
import com.sun.deploy.ref.CodeRef;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.ValidationState;
import com.sun.deploy.security.ruleset.BlockRule;
import com.sun.deploy.security.ruleset.DRSHelper;
import com.sun.deploy.security.ruleset.DefaultRule;
import com.sun.deploy.security.ruleset.ExceptionRule;
import com.sun.deploy.security.ruleset.Rule;
import com.sun.deploy.security.ruleset.RuleAction;
import com.sun.deploy.security.ruleset.RuleId;
import com.sun.deploy.security.ruleset.RuleParseException;
import com.sun.deploy.security.ruleset.RunRule;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.SessionProperties;
import com.sun.deploy.util.SessionState;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class DeploymentRuleSet {
    public static final String XML_FILENAME = "ruleset.xml";
    private static DRSHelper drsHelper;
    private static DeploymentRuleSet defaultRule;
    private static DeploymentRuleSet exceptionRule;
    private static boolean isInitialized;
    private static Exception initializationException;
    protected static final String FILENAME = "drs.properties";
    private static SessionProperties sessionProps;
    private static HashMap<CodeInstance, DeploymentRuleSet> drsMap;

    public abstract boolean isCaSignedNever();

    public abstract boolean isSelfSignedNever();

    public abstract boolean isSSVModeNever();

    public abstract boolean isRunLocalAppletsNever();

    public abstract boolean isRunUntrustedNever();

    public abstract boolean isRunUntrustedMultiClick();

    public abstract boolean isSSVModeMultiClick();

    public abstract boolean isRevocationCheckBestEffort();

    public abstract boolean isExpiredBlocked();

    public abstract boolean isPermissionsManifestRequired();

    public abstract boolean isAskGrantShowSet();

    public abstract boolean isAskGrantSelfSignedSet();

    public abstract boolean isRuleRun();

    public abstract boolean isRuleBlock();

    public abstract String getVersionString();

    public abstract boolean isVersionForced();

    public abstract String getMessage();

    public abstract Exception getException();

    public abstract boolean isLiveConnectAllowedUnchecked();

    public abstract boolean allowInsecureProperties();

    public abstract boolean allowNativeSandbox();

    public abstract boolean isUnrelatedVmSharingAllowed();

    public abstract String getCustomerString();

    public static DeploymentRuleSet getDefault() {
        if (defaultRule == null) {
            defaultRule = new DefaultRule(null, null);
        }
        return defaultRule;
    }

    public static DeploymentRuleSet getDefault(String block, String customer) {
        if (block == null && customer == null) {
            return DeploymentRuleSet.getDefault();
        }
        return new DefaultRule(block, customer);
    }

    private static DeploymentRuleSet getExceptionRule() {
        if (exceptionRule == null) {
            exceptionRule = new ExceptionRule(null, null);
        }
        return exceptionRule;
    }

    public static DeploymentRuleSet getExceptionRule(String block, String customer) {
        if (block == null && customer == null) {
            return DeploymentRuleSet.getExceptionRule();
        }
        return new ExceptionRule(block, customer);
    }

    private static DeploymentRuleSet getDefaultOrException(AppRef appRef, CodeRef codeRef, String block, String customer) {
        try {
            if (RuleId.isException(appRef, codeRef) || Environment.isGlobalException()) {
                Trace.println("Exception List entry exists for: " + String.valueOf(appRef.getLocation()) + "\nno DRS rule applies, returning Exception Rule", TraceLevel.RULESET);
                return DeploymentRuleSet.getExceptionRule(block, customer);
            }
            DeploymentRuleSet drs = DeploymentRuleSet.getDefault(block, customer);
            Trace.println("no exception applies, returning Rule: " + drs, TraceLevel.RULESET);
            return drs;
        }
        catch (BlockedException be) {
            return new BlockRule(be.getMessage(), be, true, customer);
        }
    }

    public static DeploymentRuleSet findDRS(CodeInstance ci) {
        DeploymentRuleSet drs = drsMap.get(ci);
        if (drs == null) {
            drs = DeploymentRuleSet.getDRS(ci);
            drsMap.put(ci, drs);
        }
        return drs;
    }

    private static DeploymentRuleSet getDRS(CodeInstance ci) {
        Rule result;
        AppRef appRef = ci.getAppRef();
        CodeRef codeRef = ci.getCodeRef();
        Trace.println("finding Deployment Rule Set for appRef=" + appRef + ", codeRef = " + codeRef, TraceLevel.RULESET);
        DeploymentRuleSet.initialize();
        if (initializationException != null) {
            Trace.println("Exception parsing deployment rule set " + initializationException, TraceLevel.RULESET);
            Trace.ignored(initializationException);
            String msg = ResourceManager.getString("deployment.blocked.ruleset.exception");
            if (initializationException instanceof BlockedException) {
                msg = initializationException.getMessage();
            }
            return new BlockRule(msg, initializationException, false, null);
        }
        String defaultBlockString = null;
        String defaultCustomerString = null;
        if (drsHelper != null && (result = drsHelper.findRule(appRef, codeRef)) != null) {
            Trace.println("found matching id, using rule: " + result, TraceLevel.RULESET);
            RuleAction action = result.getAction();
            if (action.isRun()) {
                RuleId id = result.getId();
                return new RunRule(action.getVersionString(), action.isVersionForced(), action.getBlockedMessage(), id.getCertHash(), id.getCertAlgorithm(), id.getLocation(), result.getCustomerString());
            }
            if (action.isBlock()) {
                return new BlockRule(action.getBlockedMessage(), null, false, result.getCustomerString());
            }
            if (action.isDefault()) {
                defaultBlockString = action.getBlockedMessage();
                defaultCustomerString = result.getCustomerString();
            }
        }
        return DeploymentRuleSet.getDefaultOrException(appRef, codeRef, defaultBlockString, defaultCustomerString);
    }

    public static synchronized void initialize() {
        if (!isInitialized) {
            drsHelper = null;
            final File rulesetJar = Config.getDRSFile();
            if (rulesetJar != null && rulesetJar.exists()) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            DeploymentRuleSet.validateDRS(rulesetJar);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    initializationException = e.getException();
                }
                catch (Exception ex) {
                    initializationException = ex;
                }
            }
            isInitialized = true;
        }
    }

    public static boolean isRuleSetFileExists() {
        File rulesetJar = Config.getDRSFile();
        return rulesetJar != null && rulesetJar.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateDRS(File rulesetJar) throws IOException {
        block5: {
            DeploymentRuleSet.verifyRuleSetFile(rulesetJar);
            try (JarFile jf = null;){
                jf = JarUtil.createJarFile(rulesetJar, false);
                JarEntry xmlEntry = jf.getJarEntry(XML_FILENAME);
                if (xmlEntry != null) {
                    drsHelper = new DRSHelper(jf.getInputStream(xmlEntry));
                    break block5;
                }
                String msg = "DeploymentRuleSet.jar is missing ruleset.xml file.";
                throw new RuleParseException(msg, null, RuleParseException.REASON_EXCEPTION, 0);
            }
        }
    }

    public static boolean installRuleSetFile(File file) {
        File target = Config.getDRSFile();
        try {
            Cache.copyFile(file, target);
            return true;
        }
        catch (Throwable t) {
            Trace.println("could not copy Deployment Rule Set file from " + file + " to " + target, TraceLevel.RULESET);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyRuleSetFile(File file) {
        String blockedKey = null;
        Exception blockedException = null;
        if (file.toString().equals(sessionProps.getProperty("drs.verified"))) {
            Trace.println("The file: " + file + " was verified before relaunch.", TraceLevel.RULESET);
            return;
        }
        JarFile jf = null;
        try {
            jf = JarUtil.createJarFile(file, true);
            JarEntry xmlEntry = jf.getJarEntry(XML_FILENAME);
            if (xmlEntry == null) {
                String msg = ResourceManager.getString("deployment.invalid.ruleset");
                throw new BlockedException(msg, null);
            }
            try {
                InputStream s = jf.getInputStream(xmlEntry);
                byte[] buffer = new byte[1024];
                int n = buffer.length;
                while (n != -1) {
                    n = s.read(buffer, 0, buffer.length);
                }
                s.close();
            }
            catch (IOException e) {
                Trace.ignored(e);
            }
            CodeSigner[] signers = xmlEntry.getCodeSigners();
            if (signers == null || signers.length == 0) {
                Trace.println("Failed to validate jar \"" + file.getAbsolutePath() + "\", the jar may be signed with a weak algorithm that is now disabled, for example MD2 or MD5. Please turn on \"-Djava.security.debug=jar\" to get more detailed trace or go to http://java.com/jcpsecurity to find more information.", TraceLevel.SECURITY);
            }
            URL location = file.toURI().toURL();
            CodeSource cs = new CodeSource(location, signers);
            boolean casigned = false;
            ValidationState state = TrustDecider.getJarValidationState(cs, null, null);
            if (state.trustDecision == 0L) {
                blockedKey = "deployment.cannot.validate";
            } else if (!state.rootCAValid) {
                blockedKey = "deployment.cannot.validate.selfsigned";
            } else if (state.certValidity != 0 || !state.timeValid) {
                blockedKey = "deployment.cannot.validate.expired";
                blockedException = state.certExpiredException != null ? state.certExpiredException : state.certNotYetValidException;
            }
        }
        catch (IOException ioe) {
            blockedKey = "deployment.cannot.validate.exception";
            blockedException = ioe;
        }
        finally {
            if (jf != null) {
                try {
                    jf.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (blockedKey != null) {
            throw new BlockedException(ResourceManager.getString(blockedKey), blockedException);
        }
        Trace.println("verification succeeded for signed Deployment Rule Set file " + file, TraceLevel.RULESET);
        sessionProps.setProperty("drs.verified", file.toString());
    }

    public String toString() {
        return "DeploymentRuleSet: generic";
    }

    public boolean skipThisCertArray(X509Certificate[] certs) {
        return false;
    }

    public boolean skipMetaInfDirectory() {
        return false;
    }

    static {
        defaultRule = null;
        exceptionRule = null;
        isInitialized = false;
        initializationException = null;
        sessionProps = new SessionProperties(FILENAME);
        SessionState.register(sessionProps);
        drsMap = new HashMap();
    }
}

