/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.trace;

import com.sun.deploy.trace.TraceListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class SocketTraceListener
implements TraceListener {
    private final String host;
    private final int port;
    private Socket socket;
    private PrintStream socketTraceStream = null;

    public SocketTraceListener(String host, int port) {
        this.host = host;
        this.port = port;
        try {
            this.socket = new Socket(host, port);
            this.socketTraceStream = new PrintStream(new BufferedOutputStream(this.socket.getOutputStream()));
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public void print(String msg) {
        if (this.socketTraceStream == null) {
            return;
        }
        this.socketTraceStream.print(msg);
        this.socketTraceStream.flush();
    }

    @Override
    public void flush() {
    }
}

